/*****************************************************************************
Copyright (C) 2026 All Rights Reserved.
by Takayuki WATANABE (University of Shizuoka),

$Version:		4. 0. 0. 1
$Author:		Takayuki WATANABE, University of Shizuoka, Japan
*****************************************************************************/
#include "System.h"
#include <iostream>

// ntdll.dllOSo[W擾邽߂̒`
typedef NTSTATUS(WINAPI* LPFN_RTLGETVERSION)(PRTL_OSVERSIONINFOEXW);

static char OSNAME[][30] = {
	"Windows 3.1", "Windows 95", "Windows 98", "Windows Me",           // 0-3
	"Windows NT", "Windows 2000", "Windows XP", "Windows Server 2003", // 4-7
	"Windows Vista", "Windows Server 2008", "Windows 7",               // 8-10
	"Windows Server 2008 R2", "Windows 8", "Windows Server 2012",      // 11-13
	"Windows 8.1", "Windows Server 2012 R2",                           // 14-15
	"Windows 10", "Windows Server 2016/2019/2022",                    // 16-17
	"Windows 11", "Unknown"                                            // 18-19
};

System::System(void)
{
}

System::~System(void)
{
}

void System::init()
{
	//VXe
	short nOsType = 19; // Default: Unknown
	int   nRamSize;

	// --- OSo[W̎擾 (RtlGetVersiongp) ---
	RTL_OSVERSIONINFOEXW osi = { sizeof(osi) };
	HMODULE hMod = GetModuleHandleA("ntdll.dll");
	if (hMod) {
		LPFN_RTLGETVERSION pRtlGetVersion = (LPFN_RTLGETVERSION)GetProcAddress(hMod, "RtlGetVersion");
		if (pRtlGetVersion) {
			pRtlGetVersion(&osi);
		}
	}
	// OS胍WbN
	if (osi.dwMajorVersion == 10) {
		if (osi.dwBuildNumber >= 22000) {
			nOsType = 18; // Windows 11
		}
		else {
			if (osi.wProductType == VER_NT_WORKSTATION) nOsType = 16; // Windows 10
			else nOsType = 17; // Windows Server 2016/2019/2022
		}
	}
	else if (osi.dwMajorVersion == 6) {
		if (osi.dwMinorVersion == 3) {
			if (osi.wProductType == VER_NT_WORKSTATION) nOsType = 14; // Windows 8.1
			else nOsType = 15; // Windows Server 2012 R2
		}
		else if (osi.dwMinorVersion == 2) {
			if (osi.wProductType == VER_NT_WORKSTATION) nOsType = 12; // Windows 8
			else nOsType = 13; // Windows Server 2012
		}
		else if (osi.dwMinorVersion == 1) {
			if (osi.wProductType == VER_NT_WORKSTATION) nOsType = 10; // Windows 7
			else nOsType = 11; // Windows Server 2008 R2
		}
		else if (osi.dwMinorVersion == 0) {
			if (osi.wProductType == VER_NT_WORKSTATION) nOsType = 8;  // Windows Vista
			else nOsType = 9;  // Windows Server 2008
		}
	}
	else if (osi.dwMajorVersion == 5) {
		if (osi.dwMinorVersion == 0) nOsType = 5;      // Windows 2000
		else if (osi.dwMinorVersion == 1) nOsType = 6; // Windows XP
		else if (osi.dwMinorVersion == 2) nOsType = 7; // Windows Server 2003
	}
	else {
		nOsType = 19; // Unknown or legacy
	}

	//Get RAM size
	MEMORYSTATUSEX MemInfo;
	MemInfo.dwLength = sizeof(MEMORYSTATUSEX);
	GlobalMemoryStatusEx(&MemInfo);
	nRamSize = (int)(MemInfo.ullTotalPhys / 1048576) + 1;

	// ̐ (sprintf_s݊̂sprintf)
	sprintf(m_sinf.desc, "%s (Build %d) / %dMB", OSNAME[nOsType], osi.dwBuildNumber, nRamSize);
	//OutputDebugString(m_sinf.desc);

	DWORD usz;
	usz = 256;
    GetComputerName(m_sinf.hostname, &usz);
	usz = 256;
    GetUserName( m_sinf.username, &usz);

	//IP
	unsigned long szip = 0;
	unsigned long szif = 0;
	PMIB_IPADDRTABLE pIPTable;
	PMIB_IFTABLE     pIFTable;
	BYTE *pIP;
	BYTE *pIF;

	//Get size of information
	GetIpAddrTable(NULL, &szip, TRUE);
	GetIfTable(NULL, &szif, TRUE);

	//Allocate memory
	pIP = new BYTE [szip];
	pIF = new BYTE [szif];

	//Get information
	GetIpAddrTable((PMIB_IPADDRTABLE)pIP, &szip, FALSE);
	GetIfTable((PMIB_IFTABLE)pIF, &szif, FALSE);

	pIPTable = (PMIB_IPADDRTABLE)pIP;
	pIFTable = (PMIB_IFTABLE)pIF;

	int i, j, ifnum;
	unsigned int n[4];
	for(i = 0; i < pIPTable->dwNumEntries; i++){
		ifnum = pIPTable->table[i].dwIndex;
		n[3] = (pIPTable->table[i].dwAddr >> 24) & 0x000000FF;
		n[2] = (pIPTable->table[i].dwAddr >> 16) & 0x000000FF;
		n[1] = (pIPTable->table[i].dwAddr >> 8) & 0x000000FF;
		n[0] = (pIPTable->table[i].dwAddr) & 0x000000FF;
		if(n[0] == 127 && n[1] == 0 && n[2] == 0 && n[3] == 1) continue;
		if(n[0] == 0 && n[1] == 0 && n[2] == 0 && n[3] == 0) continue;
		for(j = 0; j < 4; j++) m_sinf.ip[j] = n[j];

		n[3] = (pIPTable->table[i].dwMask >> 24) & 0x000000FF;
		n[2] = (pIPTable->table[i].dwMask >> 16) & 0x000000FF;
		n[1] = (pIPTable->table[i].dwMask >> 8) & 0x000000FF;
		n[0] = (pIPTable->table[i].dwMask) & 0x000000FF;
		for(j = 0; j < 4; j++) m_sinf.mask[j] = n[j];

		n[3] = ((pIPTable->table[i].dwAddr & pIPTable->table[i].dwMask) >> 24) & 0x000000FF;
		n[2] = ((pIPTable->table[i].dwAddr & pIPTable->table[i].dwMask) >> 16) & 0x000000FF;
		n[1] = ((pIPTable->table[i].dwAddr & pIPTable->table[i].dwMask) >> 8) & 0x000000FF;
		n[0] =  (pIPTable->table[i].dwAddr & pIPTable->table[i].dwMask) & 0x000000FF;
		for(j = 0; j < 4; j++) m_sinf.net[j] = n[j];
		break;
	}

	for(i = 0; i < pIFTable->dwNumEntries; i++){
		if(ifnum != pIFTable->table[i].dwIndex) continue;
		for(j = 0; j < pIFTable->table[i].dwPhysAddrLen; j++){
			m_sinf.mac[j] = pIFTable->table[i].bPhysAddr[j];
		}
	}

	delete [] pIP;
	delete [] pIF;
}

void System::print()
{
	std::cout << sizeof(SYSINFO) << std::endl;
	std::cout << m_sinf.hostname << ",   " << m_sinf.username << ",   " << m_sinf.desc << std::endl;
	std::cout << (int)m_sinf.ip[0] << "." << (int)m_sinf.ip[1] << "." << (int)m_sinf.ip[2] << "." << (int)m_sinf.ip[3] << std::endl;
	printf("%02X:%02X:%02X:%02X:%02X:%02X\n", m_sinf.mac[0], m_sinf.mac[1], m_sinf.mac[2],
		m_sinf.mac[3], m_sinf.mac[4], m_sinf.mac[5]);
}
