/*****************************************************************************
Copyright (C) 2026 All Rights Reserved.
by Takayuki WATANABE (University of Shizuoka),

$Version:		4. 0. 0. 1
$Author:		Takayuki WATANABE, University of Shizuoka, Japan
*****************************************************************************/
#include "SockUDP.h"

SockUDP::SockUDP(void)
{
	ZeroMemory(&m_from_addr, sizeof(sockaddr));
}

SockUDP::~SockUDP(void)
{
}

// OC֐ login
// unsigned int timeout	:^CAEgb
// HANDLE hStop			:ICxgnh
bool SockUDP::login(HostInfo *pHost, unsigned int timeout, HANDLE hStop)
{
	m_pHost = pHost;

	try{
		//masterȂ
		if(m_pHost->isMaster() == true){
			m_sa.sin_family = AF_INET;
			m_sa.sin_addr.s_addr = m_pHost->getIPdw();
			m_sa.sin_port = htons(m_pHost->getPort());
		}
		//agentȂ
		else{
			m_sa.sin_family = AF_INET;
			m_sa.sin_addr.s_addr = htonl(INADDR_ANY);
			m_sa.sin_port = htons(m_pHost->getPort());
		}

		//\Pbg̍쐬
		m_s = -1;
		if((m_s = socket(AF_INET, SOCK_DGRAM, 0)) == INVALID_SOCKET) throw -1;
		//agentȂ
		if(m_pHost->isMaster() == false){
			if(bind(m_s, (LPSOCKADDR)&m_sa, sizeof(m_sa)) == SOCKET_ERROR) throw -1;
		}
	}
	catch(int i)
	{
		if(m_s >= 0){
			shutdown(m_s, SD_BOTH);
			closesocket(m_s);
			m_s = -1;
		}
		return false;
	}
	return true;
}

// OAEg֐ logout
bool SockUDP::logout()
{
	if(m_s >= 0){
		shutdown(m_s, SD_SEND);
		closesocket(m_s);
		return true;
	}
	return false;
}

bool SockUDP::send(const char *buf, int len, unsigned int timeout)
{
	sendto(m_s, buf, len, 0, (struct sockaddr*)&m_sa, sizeof(m_sa));

	return true;
}

bool SockUDP::recv(char *buf, int len, unsigned int timeout)
{
	FD_SET setReady;
	TIMEVAL tout;
	int err;
	int length = sizeof(m_from_addr);

	timerclear(&tout);
    tout.tv_sec = timeout;
    tout.tv_usec = 0;

	FD_ZERO(&setReady);
	FD_SET(m_s, &setReady);
	//f[^܂ő҂
    err = select(0, &setReady, NULL, NULL, &tout);
	if(err == SOCKET_ERROR) return false;

	//\Pbg̃rbgĂ邩H
	if(FD_ISSET(m_s, &setReady)){
	    err = recvfrom(m_s, buf, len, 0, &m_from_addr, &length);
		if(err != SOCKET_ERROR) return true;
	}

	return false;
}

void SockUDP::getFromIP(unsigned char *ip)
{
	sockaddr_in *psa = (sockaddr_in*)&m_from_addr;
	ip[0] = psa->sin_addr.S_un.S_un_b.s_b1;
	ip[1] = psa->sin_addr.S_un.S_un_b.s_b2;
	ip[2] = psa->sin_addr.S_un.S_un_b.s_b3;
	ip[3] = psa->sin_addr.S_un.S_un_b.s_b4;
}
