/*****************************************************************************
Copyright (C) 2026 All Rights Reserved.
by Takayuki WATANABE (University of Shizuoka),

$Version:		4. 0. 0. 1
$Author:		Takayuki WATANABE, University of Shizuoka, Japan
*****************************************************************************/
#include "SockTCP.h"

unsigned int _stdcall connectProc(void *pinfo);
unsigned int _stdcall acceptProc(void *pinfo);

SockTCP::SockTCP(void)
{
}

SockTCP::~SockTCP(void)
{
}

// OC֐ login
// unsigned int timeout	:^CAEgb
// HANDLE hStop			:ICxgnh
bool SockTCP::login(HostInfo *pHost, unsigned int timeout, HANDLE hStop)
{
	HANDLE hEnd[2];	//Ipnh

	m_pHost = pHost;

	try{
		//masterȂ
		if(m_pHost->isMaster() == true){
			m_sa.sin_family = AF_INET;
			m_sa.sin_addr.s_addr = m_pHost->getIPdw();
			m_sa.sin_port = htons(m_pHost->getPort());
		}
		//agentȂ
		else{
			m_sa.sin_family = AF_INET;
			m_sa.sin_addr.s_addr = htonl(INADDR_ANY);
			m_sa.sin_port = htons(m_pHost->getPort());
		}

		//\Pbg̍쐬
		m_s = -1;
		if((m_s = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == INVALID_SOCKET) throw -1;
		//agentȂ
		if(m_pHost->isMaster() == false){
			if(bind(m_s, (LPSOCKADDR)&m_sa, sizeof(m_sa)) == SOCKET_ERROR) throw -1;
			if(listen(m_s, SOMAXCONN) == SOCKET_ERROR) throw -1;
		}

		//connect or accept
		//masterȂ
		if(m_pHost->isMaster() == true){
			m_hThread = (HANDLE)_beginthreadex(NULL, 0, &connectProc, this, 0, NULL);
		}
		//agentȂ
		else{
			m_hThread = (HANDLE)_beginthreadex(NULL, 0, &acceptProc, this, 0, NULL);
		}

		//^CAEg҂
		hEnd[0] = m_hThread;
		hEnd[1] = hStop == NULL ? m_hThread : hStop;
		if(timeout == -1) WaitForMultipleObjects(2, hEnd, FALSE, INFINITE);
		else{
			while(1){
				if(timeout == -1){
					TerminateThread(m_hThread, -1);
					CloseHandle(m_hThread);
					throw -2;
				}
				if(WaitForMultipleObjects(2, hEnd, FALSE, 10) != WAIT_TIMEOUT) break;
				timeout--;
			}
		}
		CloseHandle(m_hThread);
		if(isOK() == false) throw -1;

		//TCPIvV̒ǉ
/*		BOOL optval = TRUE;
		setsockopt(m_s, IPPROTO_TCP, TCP_NODELAY, (const char *)&optval, sizeof(optval));
		int szb = 0;
		setsockopt(m_s, IPPROTO_TCP, SO_RCVBUF, (const char *)&szb, sizeof(szb));
		setsockopt(m_s, IPPROTO_TCP, SO_SNDBUF, (const char *)&szb, sizeof(szb));*/
	}
	catch(int i)
	{
		if(i == -2){
			strcpy(m_err, "^CAEgG[");
		}else{/*
			LPVOID lpMsgBuf;
			FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
						NULL, WSAGetLastError(), MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR)&lpMsgBuf, 0, NULL);
			WideCharToMultiByte(CP_THREAD_ACP, NULL, (LPTSTR)&lpMsgBuf, -1, m_err, ERRBUF_SIZE, NULL, NULL);
			LocalFree(lpMsgBuf);*/
		}

		if(m_s >= 0){
			shutdown(m_s, SD_BOTH);
			closesocket(m_s);
			m_s = -1;
		}
		return false;
	}
	return true;
}

// OAEg֐ logout
bool SockTCP::logout()
{
	char buf[1024];

	if(m_s >= 0){
		shutdown(m_s, SD_SEND);

		while(::recv(m_s, buf, 1024, 0) > 0);

		closesocket(m_s);
		return true;
	}
	return false;
}

bool SockTCP::send(const char *buf, int len, unsigned int timeout)
{
	FD_SET setReady, orgReady;
	TIMEVAL tout;
	int err, ret = 0;
	unsigned int t = 0;

	timerclear(&tout);
    tout.tv_sec  = 1;
    tout.tv_usec = 0;

	FD_ZERO(&orgReady);
	FD_SET(m_s, &orgReady);
	while(ret < len)
	{
		setReady = orgReady;

		//f[^܂ő҂
		err = select(NULL, NULL, &setReady, NULL, &tout);
		if(err == SOCKET_ERROR) return false;

		//\Pbg̃rbgĂ邩H
		if(FD_ISSET(m_s, &setReady)){
			err = ::send(m_s, (char *)(buf+ret), len-ret, 0);
			if(err != SOCKET_ERROR) ret += err;
			else return false;
			if(err == 0) break;
//			fprintf(fp, "send: %d / %d\n", ret, len);
		}else{
			if(t >= timeout) return false;
			t++;
		}
	}

	return true;
}

bool SockTCP::recv(char *buf, int len, unsigned int timeout)
{
	FD_SET setReady, orgReady;
	TIMEVAL tout;
	int err, ret = 0;
	unsigned int t = 0;

	timerclear(&tout);
    tout.tv_sec  = 1;
    tout.tv_usec = 0;

	FD_ZERO(&orgReady);
	FD_SET(m_s, &orgReady);
	while(ret < len)
	{
		setReady = orgReady;

		//f[^܂ő҂
	    err = select(NULL, &setReady, NULL, NULL, &tout);
		if(err == SOCKET_ERROR) return false;

		//\Pbg̃rbgĂ邩H
		if(FD_ISSET(m_s, &setReady)){
			err = ::recv(m_s, (char *)(buf+ret), len-ret, 0);
			if(err != SOCKET_ERROR) ret += err;
			else return false;
			if(err == 0) break;
//			fprintf(fp, "recv: %d / %d\n", ret, len);
		}else{
			if(t >= timeout) return false;
			t++;
		}
	}

	return true;
}

// connectXbh
unsigned int _stdcall connectProc(void *pinfo)
{
	SockTCP *pSock = (SockTCP*)pinfo;

	if(connect(pSock->getSocket(), (LPSOCKADDR)&pSock->getSockAddr(), sizeof(SOCKADDR_IN)) == SOCKET_ERROR){
		pSock->setFAIL();
	}else{
		pSock->setOK();
	}

	_endthreadex(0);
	return 0;
}

//acceptXbh
unsigned int _stdcall acceptProc(void *pinfo)
{
	SockTCP *pSock = (SockTCP*)pinfo;

	SOCKET s;
	if((s = accept(pSock->getSocket(), NULL, NULL)) == SOCKET_ERROR){
		pSock->setFAIL();
	}else{
		closesocket(pSock->getSocket());
		pSock->setSocket(s);
		pSock->setOK();
	}

	_endthreadex(0);
	return 0;
}
