/*****************************************************************************
Copyright (C) 2026 All Rights Reserved.
by Takayuki WATANABE (University of Shizuoka),

$Version:		4. 0. 0. 1
$Author:		Takayuki WATANABE, University of Shizuoka, Japan
*****************************************************************************/
#pragma once
#include <winsock2.h>
#include <ws2tcpip.h>
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h> 
#include <commdlg.h>
#include <iostream>
#include <string>
#include <process.h>
#include "HostInfo.h"

#define ERRBUF_SIZE 512

//\Pbg{NX Sock
class Sock
{
public:
	Sock(void)
	{
		m_s = -1;
		memset(&m_sa, 0, sizeof(m_sa));
		m_pHost = NULL;
		m_err[0] = '\0';
	}
	virtual ~Sock(void){}

	virtual bool login(HostInfo *pHost, unsigned int timeout, HANDLE hStop) = 0;
	virtual bool logout() = 0;
	virtual bool send(const char *buf, int len, unsigned int timeout) = 0;
	virtual bool recv(char *buf, int len, unsigned int timeout) = 0;

	void setSocket(SOCKET s){ m_s = s; }
	void setSockAddr(SOCKADDR_IN &sa){ m_sa = sa; }

	SOCKET getSocket(){ return m_s; }
	SOCKADDR_IN &getSockAddr(){ return m_sa; }
	HostInfo *getHost(){ return m_pHost; }

	void setOK(){ m_bret = true; }
	void setFAIL(){ m_bret = false; }
	bool isOK(){ return m_bret; }

	char *getErr(){ return m_err; }

//	FILE *fp;

protected:
	//\Pbg
	SOCKET m_s;
	SOCKADDR_IN m_sa;

	//zXg
	HostInfo *m_pHost;

	//sXbh
	HANDLE m_hThread;
	unsigned int m_nThreadID;

	//sʃtO
	bool m_bret;

	//G[
	char m_err[ERRBUF_SIZE];
};
