/*****************************************************************************
Copyright (C) 2026 All Rights Reserved.
by Takayuki WATANABE (University of Shizuoka),

$Version:		4. 0. 0. 1
$Author:		Takayuki WATANABE, University of Shizuoka, Japan
*****************************************************************************/
#pragma once
#include <winsock2.h>
#include <ws2tcpip.h>
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h> 
#include <commdlg.h>
#include <iostream>
#include <string>

// zXgNX HostInfo
class HostInfo
{
public:
	HostInfo(void);
	virtual ~HostInfo(void);

	void setHostname(char *name){ m_hostname = name; }
	void setUsername(char *name){ m_username = name; }
	void setDesc(char *name){ m_desc = name; }
	void setIP(unsigned char b1, unsigned char b2, unsigned char b3, unsigned char b4);
	void setIP(unsigned char *b);
	void setIP(DWORD b);
	void setPort(unsigned short port){ m_nPort = port; }
	void setMaster(bool b){ m_bMaster = b; }

	const char *getHostname(){ return m_hostname.c_str(); }
	const char *getUsername(){ return m_username.c_str(); }
	const char *getDesc(){ return m_desc.c_str(); }
	unsigned char *getIP(){ return m_ip; }
	DWORD getIPdw(){ return *((DWORD*)m_ip); }
	unsigned short getPort(){ return m_nPort; }
	bool isMaster(){ return m_bMaster; }

	HDC getMemDC(){ return m_memDC; }
	HBITMAP getMemBM(){ return m_memBM; }
	void setMemDC(HDC dc){ m_memDC = dc; }
	void setMemBM(HBITMAP bm){ m_memBM = bm; }

	BYTE *getBuffer(){ return m_pBuffer; }
	void AllocBuffer(int sz);
	void ReleaseBuffer();

	void setHWND(HWND h){ m_hWnd = h; }
	HWND getHWND(){ return m_hWnd; }

protected:
	std::string m_hostname;	//URL or IP address
	std::string m_username; //Login user name
	std::string m_desc;		//desctiption
	unsigned char m_ip[4];	//IP address
	unsigned short m_nPort;	//tcp port number
	bool m_bMaster;			//true: master / false: agent

	HDC m_memDC;
	HBITMAP m_memBM;
	BYTE *m_pBuffer;
	HWND m_hWnd;
};
