/*****************************************************************************
Copyright (C) 2026 All Rights Reserved.
by Takayuki WATANABE (University of Shizuoka),

$Version:		4. 0. 0. 1
$Author:		Takayuki WATANABE, University of Shizuoka, Japan
*****************************************************************************/
#include "HostInfo.h"

HostInfo::HostInfo(void)
{
	*((DWORD*)m_ip) = 0;
	m_nPort = 0;
	m_bMaster = false;

	m_memDC = NULL;
	m_memBM = NULL;

	m_pBuffer = NULL;

	m_hWnd = NULL;
}

HostInfo::~HostInfo(void)
{
	if(m_memDC != NULL){
		DeleteDC(m_memDC);
		m_memDC = NULL;
	}
	if(m_memBM != NULL){
		DeleteObject(m_memBM);
		m_memBM = NULL;
	}
	ReleaseBuffer();
}

void HostInfo::setIP(unsigned char b1, unsigned char b2, unsigned char b3, unsigned char b4)
{
	m_ip[0] = b1;
	m_ip[1] = b2;
	m_ip[2] = b3;
	m_ip[3] = b4;
}

void HostInfo::setIP(unsigned char *b)
{
	m_ip[0] = b[0];
	m_ip[1] = b[1];
	m_ip[2] = b[2];
	m_ip[3] = b[3];
}

void HostInfo::setIP(DWORD b)
{
	m_ip[0] = (unsigned char)FOURTH_IPADDRESS(b);
	m_ip[1] = (unsigned char)THIRD_IPADDRESS(b);
	m_ip[2] = (unsigned char)SECOND_IPADDRESS(b);
	m_ip[3] = (unsigned char)FIRST_IPADDRESS(b);
}

void HostInfo::AllocBuffer(int sz)
{
	ReleaseBuffer();
	m_pBuffer = new BYTE [sz];
}

void HostInfo::ReleaseBuffer()
{
	if(m_pBuffer != NULL){
		delete [] m_pBuffer;
		m_pBuffer = NULL;
	}
}
