/*****************************************************************************
Copyright (C) 2026 All Rights Reserved.
by Takayuki WATANABE (University of Shizuoka),

$Version:		4. 0. 0. 1
$Author:		Takayuki WATANABE, University of Shizuoka, Japan
*****************************************************************************/
#pragma once
#include <cstdio>
#include <string>
#include "Token.h"

#define STR_MAX 1024

using namespace std;

class FileReader
{
protected:
	FILE *m_fp;
	string m_fname;
	int m_lines;

public:
	FileReader(void);
	~FileReader(void);

	bool open(const char *fname);
	bool close();
	bool get1Line(Token &token);
	bool getRaw1Line(string &str);

protected:
	void removeComment(char *str);
	void convertToken(Token &token, char *str);
};
