/*****************************************************************************
Copyright (C) 2026 All Rights Reserved.
by Takayuki WATANABE (University of Shizuoka),

$Version:		4. 0. 0. 1
$Author:		Takayuki WATANABE, University of Shizuoka, Japan
*****************************************************************************/
#include "FileReader.h"

FileReader::FileReader(void)
{
	m_fp = NULL;
	m_fname = "";
	m_lines = 0;
}

FileReader::~FileReader(void)
{
}

bool FileReader::open(const char *fname)
{
	m_fp = fopen(fname, "rt");
	if(m_fp == NULL) return false;
	return true;
}

bool FileReader::close()
{
	if(m_fp != NULL) fclose(m_fp);
	return true;
}

bool FileReader::get1Line(Token &token)
{
	long counter = 0;
	long len;
	bool flag;
	long fpos;
	char buf[STR_MAX];
	char work[STR_MAX];

	token.reset();

	//܂1sǂł݂āAt@CGhׂ
	if(fgets(buf, STR_MAX-1, m_fp) == NULL) return false;
	m_lines++;
	
	do{
		//Rg̍폜
		removeComment(buf);
		//Rs[
		for(len = 0; len < strlen(buf); len++){
			if(buf[len] == '\n' ) continue;
			work[counter++] = buf[len];
		}

		//݂̃t@C|C^ʒuۑ
		fpos = ftell(m_fp);
		//1sǂݎ
		if(fgets(buf, STR_MAX-1, m_fp) == NULL) break;
		m_lines++;
		
		//ŏ "+" Ȃps
		flag = false;
		for(len = 0; len < strlen(buf); len++){
			if(buf[len] != ' ' && buf[len] != '\t'){
				if(buf[len] == '+'){
					buf[len] = ' ';
					flag = true;
					break;
				}else if(buf[len] == '*'){
					flag = true;
					break;
				}else break;
			}
		}
	}while(flag == true);

	//Ōnull
	work[counter++] = '\0';

	//1O̍s܂Ŗ߂
	fseek(m_fp, fpos, SEEK_SET);
	m_lines--;

	convertToken(token, work);

	return true;
}

bool FileReader::getRaw1Line(string &str)
{
	char buf[STR_MAX];
	if(fgets(buf, STR_MAX-1, m_fp) == NULL) return false;

	str = buf;
	return true;
}

void FileReader::removeComment(char *str)
{
	char *tok;

	tok = strstr(str, "*");
	if(tok != NULL){
		tok[0] = '\0';
	}
}

void FileReader::convertToken(Token &token, char *str)
{
	char c;
	char entry[STR_MAX];
	int i = 0;
	int j = 0;
	int phase = 0;
	bool bflag = false;
	bool kflag = false;

	if(str == NULL) return;
	if(str[0] == 'V'){
		j = 0;
	}

	do{
		c = str[i++];
		
		switch(phase){
		//n
		case 0:
			if(c != ' ' && c != '\t' && c != '\n' && c != ',' && c != '=' && c != '(' && c != ')'){
				entry[j++] = c;
				phase = 1;
			}
			break;
		//̕񂪎n܂
		case 1:
			if(c != ' ' && c != '\t' && c != '\n' && c != ',' && c != '=' && c != '(' && c != ')'){
				entry[j++] = c;
				if(c == '\0'){
					token.add(entry);
				}
			}else{
				if(c == ')') kflag = true;
				phase = 2;
			}
			break;
		//zCgXy[X
		case 2:
			if(c != ' ' && c != '\t' && c != '\n' && c != ',' && c != '=' && c != '(' && c != ')'){
				//߂̂Ńg[N؂
//				if(c != '='){
					entry[j++] = '\0';
					token.add(entry);

					if(kflag == true){
						token.add(")");
						kflag = false;
					}

					j = 0;
					entry[j++] = c;
					phase = 1;
				//"="̂łȂĂ܂
//				}else{
//					entry[j++] = c;
//					phase = 0;
//				}
			}else{
				if(c == ')') kflag = true;
			}
			break;
		}
	}while(c != '\0');
}

