/*****************************************************************************
Copyright (C) 2026 All Rights Reserved.
by Takayuki WATANABE (University of Shizuoka),

$Version:		4. 0. 0. 1
$Author:		Takayuki WATANABE, University of Shizuoka, Japan
*****************************************************************************/
#include "ELMaster.h"

#define TBAR 76

//BELMaster
ELMaster master;

//EChE֘AO[oϐ
HINSTANCE hInst;			// ݂̃CX^X
TCHAR szTitle[256];			// ^Cg o[ eLXg
TCHAR szWindowClass[256];		// EChENX
TCHAR szWindowClassMini[256];	// EChENX
HICON hIcon;
HMENU hMenu;
HWND hWnd  = NULL;
HWND hTbar = NULL;
HWND hList = NULL;

POINT posSCR;
POINT posSCRMax;
int hwnum;
RECT rectWnd;
RECT rectTBar;
RECT rectCWnd;
bool bDual;

HANDLE hThreadMCast;
HANDLE hThreadUDP;
HANDLE hStopUdp;
HANDLE hStopUdpFinish;

// c[o[̐ݒ
TBBUTTON tbButtons [] = 
{
	{2, IDM_EXIT, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0L, 0},
	{0, 0, TBSTATE_ENABLED, TBSTYLE_SEP, 0L, 0},
	{0, IDM_SEND, TBSTATE_ENABLED, TBSTYLE_CHECK, 0L, 0},
	{1, IDM_RECV, 0, TBSTYLE_CHECK, 0L, 0}
};
#define IDW_TBAR 1234

//d3d objects
LPDIRECT3D9 d3d = NULL;
LPDIRECT3DDEVICE9 d3ddev = NULL;

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
 	// TODO: ̈ʒuɃR[hLqĂB
	MSG msg;
	WNDCLASSEX wcex;
	WNDCLASSEX wcminiex;
	
	hThreadMCast = NULL;
	hThreadUDP = NULL;

	hInst = hInstance;

	//COM̏
	::CoInitialize(NULL);

	//Windows10/11̉ʂ̊gkɑΉ
	SetProcessDpiAwarenessContext(DPI_AWARENESS_CONTEXT_PER_MONITOR_AWARE_V2);

	System sys;
	sys.init();

	//RRg[̃[h
	INITCOMMONCONTROLSEX icex;
    icex.dwSize = sizeof(INITCOMMONCONTROLSEX);
    icex.dwICC  = ICC_BAR_CLASSES | ICC_LISTVIEW_CLASSES;
    InitCommonControlsEx(&icex);

	//O[o XgO
	sprintf(szTitle, "ELMaster");
	sprintf(szWindowClass, "ELMaster");
	sprintf(szWindowClassMini, "ELMasterMini");

	hIcon = LoadIcon(hInst, (LPCTSTR)IDI_ELICON);
//	hMenu = LoadMenu(hInst, MAKEINTRESOURCE(IDR_MAINMENU));

	wcex.cbSize = sizeof(WNDCLASSEX); 
	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInst;
	wcex.hIcon			= hIcon;
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+2);
	wcex.lpszMenuName	= (LPSTR)IDR_MAINMENU;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= hIcon;
	RegisterClassEx( &wcex );
	
	wcminiex.cbSize = sizeof(WNDCLASSEX); 
	wcminiex.style			= CS_HREDRAW | CS_VREDRAW;
	wcminiex.lpfnWndProc	= (WNDPROC)WndProcMini;
	wcminiex.cbClsExtra		= 0;
	wcminiex.cbWndExtra		= 0;
	wcminiex.hInstance		= hInst;
	wcminiex.hIcon			= hIcon;
	wcminiex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcminiex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+2);
	wcminiex.lpszMenuName	= NULL;
	wcminiex.lpszClassName	= szWindowClassMini;
	wcminiex.hIconSm		= hIcon;
	RegisterClassEx( &wcminiex );
	
	//EChE̍쐬
	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, 840, 480, NULL, NULL, hInst, NULL);
	if( !hWnd ) return FALSE;
	GetWindowRect(hWnd, &rectWnd);
	GetClientRect(hWnd, &rectCWnd);

	//c[o[̍쐬
	hTbar = CreateToolbarEx(hWnd, WS_CHILD | WS_VISIBLE | WS_BORDER | TBSTYLE_TOOLTIPS | TBSTYLE_LIST,
				IDW_TBAR, 3, hInst, IDB_TOOLBAR, 
				(LPCTBBUTTON)&tbButtons, 4, 90, 0, 64, 64, sizeof (TBBUTTON));
	SetWindowPos(hTbar, NULL, 0, 0, 1280, TBAR, SWP_NOMOVE);
	GetClientRect(hTbar, &rectTBar);

	//Xgr[̍쐬
	hList = CreateWindowEx(0, WC_LISTVIEW, 0, WS_CHILD | LVS_REPORT | WS_VISIBLE | WS_VSCROLL | LVS_OWNERDRAWFIXED,
				0, rectTBar.bottom+3, 1280, 800,
                hWnd, (HMENU)1, hInst, NULL); 
	ListView_SetExtendedListViewStyle(hList, LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);
	LVCOLUMN col;
	LVITEM item = {0};
	col.mask = LVCF_FMT | LVCF_TEXT | LVCF_WIDTH | LVCF_SUBITEM;
	col.fmt = LVCFMT_LEFT;
	col.cx = 200;
	col.iSubItem = 0;
	col.pszText = TEXT("zXg");
	ListView_InsertColumn(hList , 0 , &col);
	col.iSubItem = 1;
	col.pszText = TEXT("IPAhX");
	ListView_InsertColumn(hList , 1 , &col);
	col.iSubItem = 2;
	col.pszText = TEXT("[U");
	ListView_InsertColumn(hList , 2 , &col);
	col.iSubItem = 3;
	col.pszText = TEXT("vr[");
	ListView_InsertColumn(hList , 3 , &col);

	HIMAGELIST hImgList = ImageList_Create(15, 150, ILC_COLOR4, 5, 0);
    ListView_SetImageList(hList, hImgList, LVSIL_SMALL);
	
	initD3d(hWnd);

	//EChE\
	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);

	//ELMasteȑ
	master.init();
	master.startupMCast();

//	GetWindowRect(hWnd, &rectWnd);

	bDual = master.getMonitor().isDual();
	posSCR.x = posSCR.y = 0;
	posSCRMax.x = posSCRMax.y = 0;
	hwnum = 1;

	// C bZ[W [v:
	while( GetMessage(&msg, NULL, 0, 0) ){
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}

	DeleteObject(hImgList);

	//ELMasteȑI
	master.cleanupMCast();
	master.destroy();

	releaseD3d();

	//COM̏I
	::CoUninitialize();

	return msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	static int cnt = 0;
	static bool budpfirst = true;

	switch( message ) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// j[Ỉ:
			switch( wmId ) 
			{
				case IDM_ABOUT:
					DialogBox(hInst, (LPCTSTR)IDD_ABOUT, hWnd, (DLGPROC)aboutProc);
					break;
				case IDM_SETUP:
					DialogBox(hInst, (LPCTSTR)IDD_SETUP, hWnd, (DLGPROC)setupProc);
					break;
				case IDM_EXIT:
					DestroyWindow(hWnd);
					break;
				case IDM_SEND:
					{
						if(master.m_bStartMCast == false){
							master.m_bStartMCast = true;
							//Recv{^̗L
							//SendMessage(hTbar, TB_SETSTATE, (WPARAM)IDM_RECV, (LPARAM)MAKELONG(TBSTATE_ENABLED, 0));
							//Agent̃EChEJ
							if(WaitForSingleObject(hThreadMCast, DEFAULT_TIMEUP) != WAIT_TIMEOUT){
								master.sendWindowShow();
							}
//							//0.25bԊu
//							SetTimer(hWnd, 0, 250, NULL);
							//0.05bԊu
							SetTimer(hWnd, 0, 50, NULL);
						}else{
							master.m_bStartMCast = false;
							KillTimer(hWnd, 0);
							//~Agent̃EChEB
							if(WaitForSingleObject(hThreadMCast, DEFAULT_TIMEUP) != WAIT_TIMEOUT){
								master.sendWindowHide();
							}
							//Recv{^̖
							SendMessage(hTbar, TB_SETSTATE, (WPARAM)IDM_RECV, 0L);
							if(master.m_bStartUDP == true){
								PostMessage(hWnd, WM_COMMAND, (WPARAM)IDM_RECV, 0L);
							}
						}
					}
					break;
				case IDM_RECV:
					MessageBox(hWnd, "̋@\͌ݖł", "", MB_OK | MB_ICONINFORMATION);
					break; //
					{
						if(master.m_bStartUDP == false){
							master.startupUDP();
							initListEntry();

							if(WaitForSingleObject(hThreadUDP, DEFAULT_TIMEUP) != WAIT_TIMEOUT){
								hStopUdp = _AUTOEVENT;
								unsigned int threadID;
								hThreadUDP = (HANDLE)_beginthreadex(NULL, 0, &recvUdpThread, NULL, 0, &threadID);
							}

							budpfirst = true;
							master.m_bStartUDP = true;

						}else{
							master.m_bStartUDP = false;

							hStopUdpFinish = _AUTOEVENT;
							SetEvent(hStopUdpFinish);
							WaitForSingleObject(hStopUdpFinish, INFINITE);

							_DELEVENT(hStopUdp);
							_DELEVENT(hStopUdpFinish);

							TerminateThread(hThreadUDP, 0);
							master.cleanupUDP();
						}
					}
					break;
				case IDM_COUNT:
					MessageBox(hWnd, "̋@\͌ݖł", "", MB_OK | MB_ICONINFORMATION);
					break; //
					//DialogBox(hInst, (LPCTSTR)IDD_SCOUNT, hWnd, (DLGPROC)scountProc);
					{
						FILE *fp = fopen("o.txt", "wt");
						int loop;

						for(loop = 0; loop < master.m_phi.size(); loop++){
							if(strlen(master.m_phi[loop]->getUsername()) != 0){
								fprintf(fp, "%s\n", master.m_phi[loop]->getUsername());
							}
						}
						fclose(fp);
					}
					break;
				default:
					return DefWindowProc( hWnd, message, wParam, lParam );
			}
			break;
		case WM_TIMER:
			{
				if(master.m_bStartMCast == false) break;
				KillTimer(hWnd, 0);
				cnt++;

				//EChEJiĊmFj0.25 * 40 = 10b
				// // 0.05s * 100 = 5s
//				if(cnt % 40 == 0){
				if(cnt % 100 == 0){
					if(WaitForSingleObject(hThreadMCast, DEFAULT_TIMEUP) != WAIT_TIMEOUT){
						master.sendWindowShow();
					}
				}

				//NCAg̎W 0.25 * 480 = 120b
//				if((cnt % 240 == 0 || budpfirst == true) && master.m_bStartUDP == true){
				if((cnt % 3600 == 0 || budpfirst == true) && master.m_bStartUDP == true){
					budpfirst = false;
					if(WaitForSingleObject(hThreadMCast, DEFAULT_TIMEUP) != WAIT_TIMEOUT){
						master.sendUdpCmd(ELP_GET_INFO);
					}
				}

				//SPEED = 1  100A܂ 0.1s  10s
				if(cnt % (master.getSpeed()*2) == 0){
					if(WaitForSingleObject(hThreadMCast, DEFAULT_TIMEUP) != WAIT_TIMEOUT){
						unsigned int threadID;
						hThreadMCast = (HANDLE)_beginthreadex(NULL, 0, &sendMCastThread, NULL, 0, &threadID);
					}
				}
//				SetTimer(hWnd, 0, 250, NULL);
				SetTimer(hWnd, 0, 50, NULL);
			}
			break;
		case WM_NOTIFY:
			switch (((LPNMHDR) lParam)->code) 
			{ 
				case TTN_GETDISPINFO: 
				{ 
		            LPTOOLTIPTEXT lpttt; 

		            lpttt = (LPTOOLTIPTEXT) lParam; 
		            lpttt->hinst = hInst; 

					int idButton = lpttt->hdr.idFrom; 
					switch (idButton) 
					{ 
						case IDM_EXIT: 
							lpttt->lpszText = MAKEINTRESOURCE(IDS_EXIT); 
							break; 
						case IDM_SEND: 
							lpttt->lpszText = MAKEINTRESOURCE(IDS_SEND); 
							break; 
						case IDM_RECV: 
							lpttt->lpszText = MAKEINTRESOURCE(IDS_RECV); 
							break; 
					} 
					break; 
				} 
				
				case NM_DBLCLK:  // ڂ_uNbN
				{
					LV_HITTESTINFO lvinfo;
					GetCursorPos((LPPOINT)&lvinfo.pt);
					ScreenToClient(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &lvinfo.pt);
					ListView_HitTest(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &lvinfo);
					if ((lvinfo.flags & LVHT_ONITEM) != 0)
					{
						//EChE̍쐬
						HWND hw = CreateWindow(szWindowClassMini, szTitle, WS_OVERLAPPEDWINDOW,
						  CW_USEDEFAULT, 0, 640, 480, NULL, NULL, hInst, NULL);
						if(!hw) return FALSE;
						master.m_phi[lvinfo.iItem]->setHWND(hw);
						SetWindowLongPtr(hw, GWLP_USERDATA, (LONG_PTR)master.m_phi[lvinfo.iItem]);
						//EChE\
						ShowWindow(hw, SW_SHOW);
						UpdateWindow(hw);
						SetWindowText(hw, master.m_phi[lvinfo.iItem]->getUsername());
					}
		            break;
				}

				default: 
		            break;
			}
		case WM_PAINT:
			hdc = BeginPaint (hWnd, &ps);
			EndPaint(hWnd, &ps);
			break;

		case WM_DRAWITEM:
            drawListItem((LPDRAWITEMSTRUCT)lParam);
            break;

		case WM_SIZE:
			{
				SetWindowPos(hTbar, NULL, 0, 0, LOWORD(lParam), TBAR, SWP_NOMOVE);
				SetWindowPos(hList, NULL, 0, rectTBar.bottom+3, LOWORD(lParam), HIWORD(lParam)-(rectTBar.bottom+3), SWP_NOMOVE);
				GetWindowRect(hWnd, &rectWnd);
				GetClientRect(hWnd, &rectCWnd);
			}
			break;

		case WM_DESTROY:
			if(WaitForSingleObject(hThreadMCast, DEFAULT_TIMEUP) != WAIT_TIMEOUT){
				master.sendWindowHide();
			}

			PostQuitMessage(0);
			break;

		default:
			return DefWindowProc( hWnd, message, wParam, lParam );
   }
   return 0;
}

LRESULT CALLBACK WndProcMini(HWND hWndm, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch( message ) 
	{
		case WM_PAINT:
			hdc = BeginPaint (hWndm, &ps);
			{
				HostInfo *phi = (HostInfo*)GetWindowLongPtr(hWndm, GWLP_USERDATA);
				SetStretchBltMode(hdc, COLORONCOLOR);
				if(phi->getMemDC() != NULL){
					RECT rc;
					GetClientRect(hWndm, &rc);
					StretchBlt(hdc, 0, 0, rc.right, rc.bottom, phi->getMemDC(),
						0, 0, master.m_dskWidth, master.m_dskHeight, SRCCOPY);
				}
			}
			EndPaint( hWndm, &ps );
			break;

		case WM_SIZE:
			break;

		case WM_DESTROY:
		case WM_CLOSE:
			DestroyWindow(hWndm);
			break;
		default:
			return DefWindowProc( hWndm, message, wParam, lParam );
   }
   return 0;
}

// o[W{bNXpbZ[W nh
LRESULT CALLBACK aboutProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
				return TRUE;

		case WM_COMMAND:
			if(LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL){
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

// ݒ_CAOpbZ[W nh
LRESULT CALLBACK setupProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	unsigned char *b;
	unsigned char bbb[4];
	DWORD bb;
	switch(message)
	{
		case WM_INITDIALOG:
			{
				SendDlgItemMessage(hDlg, IDC_QFACTOR, TBM_SETRANGE, TRUE, MAKELONG(1, 80));
				SendDlgItemMessage(hDlg, IDC_QFACTOR, TBM_SETPOS, TRUE, master.getQfactor());
				SendDlgItemMessage(hDlg, IDC_SPEED, TBM_SETRANGE, TRUE, MAKELONG(1, 100));
				SendDlgItemMessage(hDlg, IDC_SPEED, TBM_SETPOS, TRUE, master.getSpeed());
				b = master.getMcastAddr();
				SendDlgItemMessage(hDlg, IDC_MCASTIP, IPM_SETADDRESS, 0, MAKEIPADDRESS(b[0], b[1], b[2], b[3]));
				b = master.getTCPAddr0();
				SendDlgItemMessage(hDlg, IDC_IPSTART, IPM_SETADDRESS, 0, MAKEIPADDRESS(b[0], b[1], b[2], b[3]));
				b = master.getTCPAddr1();
				SendDlgItemMessage(hDlg, IDC_IPEND, IPM_SETADDRESS, 0, MAKEIPADDRESS(b[0], b[1], b[2], b[3]));
			}
			return TRUE;

		case WM_COMMAND:
			if(LOWORD(wParam) == IDOK){
				master.setQfactor(SendDlgItemMessage(hDlg, IDC_QFACTOR, TBM_GETPOS, 0, 0));
				master.setSpeed(SendDlgItemMessage(hDlg, IDC_SPEED, TBM_GETPOS, 0, 0));
				SendDlgItemMessage(hDlg, IDC_MCASTIP, IPM_GETADDRESS, 0, (LPARAM)&bb);
				bbb[0] = FIRST_IPADDRESS(bb);
				bbb[1] = SECOND_IPADDRESS(bb);
				bbb[2] = THIRD_IPADDRESS(bb);
				bbb[3] = FOURTH_IPADDRESS(bb);
				master.setMcastAddr(bbb);
				SendDlgItemMessage(hDlg, IDC_IPSTART, IPM_GETADDRESS, 0, (LPARAM)&bb);
				bbb[0] = FIRST_IPADDRESS(bb);
				bbb[1] = SECOND_IPADDRESS(bb);
				bbb[2] = THIRD_IPADDRESS(bb);
				bbb[3] = FOURTH_IPADDRESS(bb);
				master.setTCPAddr0(bbb);
				SendDlgItemMessage(hDlg, IDC_IPEND, IPM_GETADDRESS, 0, (LPARAM)&bb);
				bbb[0] = FIRST_IPADDRESS(bb);
				bbb[1] = SECOND_IPADDRESS(bb);
				bbb[2] = THIRD_IPADDRESS(bb);
				bbb[3] = FOURTH_IPADDRESS(bb);
				master.setTCPAddr1(bbb);
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}else if(LOWORD(wParam) == IDCANCEL){
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

// ݒ_CAOpbZ[W nh
LRESULT CALLBACK scountProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	unsigned char *b;
	DWORD bb;
	switch(message)
	{
		case WM_INITDIALOG:
			{
				int loop;

				for(loop = 0; loop < master.m_phi.size(); loop++){
					if(strlen(master.m_phi[loop]->getUsername()) != 0){
						SendDlgItemMessage(hDlg, IDC_SCOUNT, EM_REPLACESEL, true, (LPARAM)master.m_phi[loop]->getUsername());
					}
				}
				b = master.getMcastAddr();
			}
			return TRUE;

		case WM_COMMAND:
			if(LOWORD(wParam) == IDOK){
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

unsigned int __stdcall sendMCastThread(void *pinfo)
{
	captureScreenD3d();
	//ʃLv`
/*	HDC dskDC = ::GetDC(::GetDesktopWindow());
	BitBlt(master.m_memDC, 0, 0, master.m_dskWidth, master.m_dskHeight, dskDC, 0, 0, SRCCOPY);
	::ReleaseDC(::GetDesktopWindow(), dskDC);
*/
	//}EX|C^̕`
	CURSORINFO csi = { sizeof(CURSORINFO) };
	ICONINFO ii;
	GetCursorInfo(&csi);
	GetIconInfo(csi.hCursor, &ii);
	DrawIcon(master.m_memDC, csi.ptScreenPos.x-ii.xHotspot, csi.ptScreenPos.y-ii.yHotspot, csi.hCursor);
	DeleteObject(ii.hbmColor);
    DeleteObject(ii.hbmMask);

	//rbg}bvf[^̎擾
	BITMAPINFO info;
	ZeroMemory(&info, sizeof(BITMAPINFO));
	info.bmiHeader.biSize = sizeof(BITMAPINFO);
	int sz;
	BYTE *pData;
	GetDIBits(master.m_memDC, master.m_memBM, 0, master.m_dskHeight, NULL, &info, DIB_RGB_COLORS);
	sz = info.bmiHeader.biSizeImage;
	info.bmiHeader.biPlanes = 1;
	info.bmiHeader.biCompression = BI_RGB;
	info.bmiHeader.biBitCount = 24;
	info.bmiHeader.biHeight = -master.m_dskHeight;
	pData = new BYTE [sz];
	//fobOp
	std::wstring msg = std::to_wstring(master.m_dskHeight) + L" " + std::to_wstring(sz) + L"\n";
	OutputDebugStringW(msg.c_str());

	GetDIBits(master.m_memDC, master.m_memBM, 0, master.m_dskHeight, pData, &info, DIB_RGB_COLORS);
	master.sendJPEG(pData, master.getQfactor());

	delete [] pData;

	_endthreadex(0);

	return 0;
}

unsigned int __stdcall sendUdpThread(void *pinfo)
{
	bool bret;

	bret = master.sendUdpCmd(0);

	_endthreadex(0);

	return 0;
}

unsigned int __stdcall recvUdpThread(void *pinfo)
{
	while(1){
		if(WaitForSingleObject(hStopUdp, 0) == WAIT_OBJECT_0){
			SetEvent(hStopUdpFinish);
			_endthreadex(0);
			return 0;
		}
		master.recvUDP();
	}

	_endthreadex(0);
	return 0;
}

void initListEntry()
{
	ListView_DeleteAllItems(hList);

    LV_ITEM itm;
	int loop;
	for(loop = 0; loop < master.m_phi.size(); loop++){
		char str[1024];
		sprintf(str, "%d.%d.%d.%d", master.m_phi[loop]->getIP()[0], master.m_phi[loop]->getIP()[1], 
											master.m_phi[loop]->getIP()[2], master.m_phi[loop]->getIP()[3]);
		itm.mask = LVIF_TEXT;
		itm.iItem = loop;
		itm.pszText = TEXT("N/A");
		itm.iSubItem = 0;
		ListView_InsertItem(hList, &itm);
		itm.pszText = str;
		itm.iSubItem = 1;
		ListView_SetItem(hList, &itm);
	}
}

//̕\
void DrawListItemText(HDC hdc,char *Text, RECT *rc,int fmt)
{
    DRAWTEXTPARAMS  DrawTextExParam;
    int     Justify;

    //ׂ荇񂪂Ȃ悤ɍEɃ}[WB
    //AE}[W͕̔zuE񂹂ɂƂtB
    DrawTextExParam.cbSize=sizeof(DrawTextExParam);
    DrawTextExParam.iLeftMargin=2;
    DrawTextExParam.iRightMargin=0;
    DrawTextExParam.iTabLength=0;
    DrawTextExParam.uiLengthDrawn=0;

    //TuACe̔̕zu𒲂ׂāADrawTextExp̃X^CɒB
    if((fmt & LVCFMT_JUSTIFYMASK)==LVCFMT_LEFT)         Justify=DT_LEFT;
    else if((fmt & LVCFMT_JUSTIFYMASK)==LVCFMT_RIGHT){  Justify=DT_RIGHT;
                                                        DrawTextExParam.iRightMargin=6;}
    else                                                Justify=DT_CENTER;
    //̕\@E}[W̂DrawTextExgĂB
    DrawTextEx(hdc,Text, lstrlen(Text),rc,
        Justify | DT_VCENTER | DT_SINGLELINE | DT_END_ELLIPSIS,
        &DrawTextExParam);
}

void drawListItem(LPDRAWITEMSTRUCT lpDraw)
{
    HDC         hdc;                //foCXReLXg
    RECT        rc, rcAll;              
    HBRUSH      hBrush;         //wi`p̃uVnh
    COLORREF    Color;
    char        Text[256];
    int         SubItem;
    LVCOLUMN    LvColumn;   //񍀖ڎ擾p̍\
    LVITEM      LvItem;         //ACe擾p̍\
    int         SubItemNum;

    hdc = lpDraw->hDC;
	//foCXReLXgۑ
    SaveDC(hdc);
    //̔wi̕\[h񓧉߂ɐݒ肷B
    SetBkMode(hdc,OPAQUE);
    //ODS_SELECTEDtOƂɂ́A\B
    if (lpDraw->itemState & ODS_SELECTED) {
        //wiF̎擾
        hBrush=CreateSolidBrush (GetSysColor(COLOR_HIGHLIGHT));
        SetBkColor(hdc, GetSysColor(COLOR_HIGHLIGHT));
        SetTextColor(hdc, GetSysColor(COLOR_HIGHLIGHTTEXT));
    }else{
        Color=ListView_GetTextBkColor(hList);
        //ListView_SetTextBkColorxĂȂƂɂ́Aff000000ƂFɂȂ̂
        //̎ɂ́AVXe̐FgBȂƍɂȂĂ܂B
        if(Color & 0xff000000) Color=GetSysColor(COLOR_WINDOW);
        hBrush=CreateSolidBrush (Color);
    }

    //񌩏õtH[}bg擾B
    ZeroMemory(&LvColumn,sizeof(LvColumn));
    LvColumn.mask=LVCF_FMT;
    ListView_GetColumn(hList,0,&LvColumn);

    //wi𖄂߂
    ListView_GetItemRect(hList, lpDraw->itemID, &rcAll, LVIR_LABEL);
    ListView_GetSubItemRect(hList, lpDraw->itemID, 3, LVIR_LABEL, &rc);
    rcAll.left = 0;
	rcAll.right = rc.right;
	FillRect(hdc, &rcAll, hBrush);

    ZeroMemory(&LvItem, sizeof(LvItem));
    LvItem.iItem = lpDraw->itemID;
    LvItem.iSubItem = 0;
    LvItem.mask = LVIF_TEXT | LVIF_IMAGE;
    LvItem.pszText = Text;
    LvItem.cchTextMax = sizeof(Text);
    ListView_GetItem(hList, &LvItem);

    //\BListView_GetItemRectgƕ\̈悪B
    ListView_GetItemRect(hList, lpDraw->itemID, &rc, LVIR_LABEL);
	DrawListItemText(hdc, Text, &rc, LvColumn.fmt);

    ListView_GetItemText(hList, lpDraw->itemID, 1, Text, sizeof(Text));
    ListView_GetSubItemRect(hList, lpDraw->itemID, 1, LVIR_LABEL, &rc);
    DrawListItemText(hdc, Text, &rc, LvColumn.fmt);

    ListView_GetItemText(hList, lpDraw->itemID, 2, Text, sizeof(Text));
    ListView_GetSubItemRect(hList, lpDraw->itemID, 2, LVIR_LABEL, &rc);
    DrawListItemText(hdc, Text, &rc, LvColumn.fmt);

	SetStretchBltMode(hdc, COLORONCOLOR);
	if(master.m_phi[lpDraw->itemID]->getMemDC() != NULL){
	    ListView_GetSubItemRect(hList, lpDraw->itemID, 3, LVIR_LABEL, &rc);
		StretchBlt(hdc, rc.left, rc.top, rc.right-rc.left, rc.bottom-rc.top, 
			master.m_phi[lpDraw->itemID]->getMemDC(),
			0, 0, master.m_dskWidth, master.m_dskHeight, SRCCOPY);
	}

	//uV̍폜
    DeleteObject(hBrush);
    //foCXReLXg̕
    RestoreDC(hdc,-1);
}

void initD3d(HWND hwnd)
{
    d3d = Direct3DCreate9(D3D_SDK_VERSION);
    D3DPRESENT_PARAMETERS d3dpp;
    ZeroMemory(&d3dpp, sizeof(d3dpp));
    d3dpp.Windowed = TRUE;
    d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
    d3dpp.hDeviceWindow = hwnd;
    d3d->CreateDevice(D3DADAPTER_DEFAULT,
                      D3DDEVTYPE_HAL,
                      hwnd,
                      D3DCREATE_SOFTWARE_VERTEXPROCESSING,
                      &d3dpp,
                      &d3ddev);
}

void captureScreenD3d()
{
    UINT screenW = GetSystemMetrics(SM_CXSCREEN);
    UINT screenH = GetSystemMetrics(SM_CYSCREEN);
    LPDIRECT3DSURFACE9 pSurface;
    d3ddev->CreateOffscreenPlainSurface(screenW, screenH, D3DFMT_A8R8G8B8, D3DPOOL_SYSTEMMEM, &pSurface, NULL);
    d3ddev->GetFrontBufferData(0, pSurface);
//    D3DXSaveSurfaceToFile(L"screen.bmp",D3DXIFF_BMP,pSurface,NULL,NULL);
	HDC dskDC;
//	d3ddev->GetBackBuffer(0,0,D3DBACKBUFFER_TYPE_MONO,&pSurface);
	pSurface->GetDC(&dskDC);
	BitBlt(master.m_memDC, 0, 0, master.m_dskWidth, master.m_dskHeight, dskDC, 0, 0, SRCCOPY);
	pSurface->ReleaseDC(dskDC);
    pSurface->Release();
}

void releaseD3d()
{
    d3ddev->Release();
    d3d->Release();
}
