/*----------------------------------------------------------------------
ELAssit - ELMaster

Copyright (c) 2026, Takayuki WATANABE, All Rights Reserved.
http://www.groundnode.com/

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

$Version:		4. 0. 0. 1
$Data:		    Feb 11 2026
$Author:		Takayuki WATANABE
----------------------------------------------------------------------*/
#pragma once

#include <winsock2.h>
#include <ws2tcpip.h>
#include <windows.h>
#include <gdiplus.h>
#include <windowsx.h>
#include <wincodec.h>
#include <wincodecsdk.h>
#include <commctrl.h> 
#include <commdlg.h>
#include <string.h>
#include <process.h>
#include <iostream>
#include <vector>
#include <d3d9.h>
#include "../Util/System.h"
#include "../Util/Monitor.h"
#include "../Util/FileReader.h"
#include "../Util/SockTCP.h"
#include "../Util/SockUDP.h"
#include "../Util/SockUDPM.h"
#include "../Util/picojson.h"
#include "resource.h"
//NCu
#pragma comment(lib, "ws2_32.lib")
#pragma comment(lib, "comctl32.lib")
#pragma comment(lib, "WindowsCodecs.lib")
#pragma comment(lib, "d3d9.lib")

# pragma pack (1)

//Cxg}N
#define _INITEVENT(ev)	{ ev = CreateEvent(NULL, FALSE, FALSE, NULL); }
#define _DELEVENT(ev)	{ CloseHandle(ev); }
#define _AUTOEVENT		CreateEvent(NULL, FALSE, FALSE, NULL)

//lbg[N֘AftHgl
#define DEFAULT_UDPPORT		9375
#define DEFAULT_MCASTPORT	9376
#define DEFAULT_MCASTADDR	"224.1.2.3"
#define DEFAULT_MCASTGRP	0
#define DEFAULT_IPSTART		"192.168.1.1"
#define DEFAULT_IPEND		"192.168.1.75"
#define DEFAULT_TIMEUP		10000

//obt@TCY
#define MCAST_BUFFER_SIZE	1000000
#define UDP_BUFFER_SIZE		1000000
#define FRAMESIZE			1400

//t@C
#define INIFILE				"elmaster.ini"
#define LOGFILE				"elmaster.log"

//vgR
#define ELP_HIDE_WINDOW			0x00
#define ELP_SHOW_WINDOW			0x01
#define ELP_SEND_JPEG			0x02
#define ELP_GET_INFO			0x03
#define ELP_SEND_INFO			0x04

//}`LXgwb_tH[}bg
struct MCAST_HEADER
{
	unsigned char group_id;		//O[vԍi0-255j
	unsigned char message;		//vgR
	unsigned int file_size;		//t@CTCY
	unsigned int frame_size;	//t[TCY
	unsigned int position;		//ʒu
	unsigned short width;		//
	unsigned short height;		//
	bool bend;					//t@CIw
};

//UDPX|Xwb_tH[}bg
struct UDP_RES_HEADER
{
	unsigned short client_id;	//NCAgԍi0-65,535j
	unsigned char message;		//vgR
	unsigned int file_size;		//t@CTCY
	unsigned int frame_size;	//t[TCY
	unsigned int position;		//ʒu
	unsigned short width;		//
	unsigned short height;		//
	bool bend;					//t@CIw
};

//ELMasterNX
class ELMaster
{
public:
	ELMaster(void);
	virtual ~ELMaster(void);

	bool init();
	bool destroy();

	//}`LXg
	bool startupMCast();
	bool cleanupMCast();
	bool sendJPEG(BYTE *pData, int qfactor);
	bool sendWindowHide();
	bool sendWindowShow();

	//UDP
	bool startupUDP();
	bool cleanupUDP();
	bool sendUdpCmd(unsigned char cmd);
	bool recvUDP();

	void writeLog(char *str);

	Monitor &getMonitor(){ return m_mon; }
	int getQfactor(){ return m_qfactor; }
	int getSpeed(){ return m_speed; }
	void setQfactor(int q){ m_qfactor = q; }
	void setSpeed(int s){ m_speed = s; }
	unsigned char *getMcastAddr(){ return m_hudpm.getIP(); }
	void setMcastAddr(unsigned char *b){ m_hudpm.setIP(b); }
	unsigned char *getTCPAddr0(){ return m_UDPAddr0; }
	void setTCPAddr0(unsigned char *b){
		*((DWORD*)m_UDPAddr0) = *((DWORD*)b);
	}
	unsigned char *getTCPAddr1(){ return m_UDPAddr1; }
	void setTCPAddr1(unsigned char *b){
		*((DWORD*)m_UDPAddr1) = *((DWORD*)b);
	}

	//th֐
	friend LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
	friend LRESULT CALLBACK WndProcMini(HWND, UINT, WPARAM, LPARAM);
	friend LRESULT CALLBACK aboutProc(HWND, UINT, WPARAM, LPARAM);
	friend LRESULT CALLBACK setupProc(HWND, UINT, WPARAM, LPARAM);
	friend LRESULT CALLBACK scountProc(HWND, UINT, WPARAM, LPARAM);
	friend void initListEntry();
    friend void drawListItem(LPDRAWITEMSTRUCT lParam);
	friend unsigned int __stdcall sendMCastThread(void *pinfo);
	friend unsigned int __stdcall sendUdpThread(void *pinfo);
	friend unsigned int __stdcall recvUdpThread(void *pinfo);
	friend void initD3d(HWND hwnd);
	friend void captureScreenD3d();
	friend void releaseD3d();
	
protected:
	//IP}`LXgp
	SockUDPM m_sudpm;
	HostInfo m_hudpm;
	DWORD m_MCastGrp;

	//UDPp
	unsigned char m_UDPAddr0[4];
	unsigned char m_UDPAddr1[4];
	std::vector<HostInfo*> m_phi;
	SockUDP m_sudp;
	HostInfo m_hudp;

	//}`LXgMp/////////////////////////////////////////////////////
	HDC m_memDC;
	HBITMAP m_memBM;
	BITMAPINFO m_infoBM;
	int m_dskWidth;
	int m_dskHeight;
	BYTE *m_pMCastData;
	BYTE *m_pMCastData0;
	int m_qfactor;
	int m_speed;

	IWICImagingFactory *m_piFactory;
	IWICBitmapEncoder *m_piEncoder;
	IWICBitmapFrameEncode *m_piBitmapFrame;
	IPropertyBag2 *m_pPropertybag;
	IWICStream *m_piStream;
	UINT m_cbStride;
    UINT m_cbBufferSize;

	//Mp/////////////////////////////////////////////////////
	BYTE *m_pFrame;
	BYTE *m_pBM_r;

	IWICImagingFactory *m_piFactory_r;
	IWICBitmapDecoder *m_piDecoder_r;
	IWICBitmapFrameDecode *m_piDecodeFrame_r;
	IPropertyBag2 *m_pPropertybag_r;
	IWICStream *m_piStream_r;
	UINT m_cbStride_r;
    UINT m_cbBufferSize_r;

	bool m_bStartMCast;
	bool m_bStartUDP;

	Monitor m_mon;		//j^

	FILE *m_fplog;
};
