/*----------------------------------------------------------------------
ELAssit - ELMaster

Copyright (c) 2013, Takayuki WATANABE, All Rights Reserved.
http://www.groundnode.com/

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

$Version:		4. 0. 0. 1
$Data:		    Feb 11 2016
$Author:		Takayuki WATANABE
----------------------------------------------------------------------*/
#include "ELMaster.h"

extern HWND hList;

ELMaster::ELMaster(void)
{
	m_bStartMCast = false;
	m_bStartUDP = false;

	// }`LXgAhX
	m_hudpm.setIP(inet_addr(DEFAULT_MCASTADDR));
	m_hudpm.setPort(DEFAULT_MCASTPORT);
	m_hudpm.setMaster(true);

	m_MCastGrp = DEFAULT_MCASTGRP;
	m_qfactor = 20;
	m_speed = 10;

	//WIC
	m_piFactory = NULL;
	m_piEncoder = NULL;
	m_piBitmapFrame = NULL;
	m_pPropertybag = NULL;
	m_piStream = NULL;

	// UDPpIPAhX
	*((DWORD*)m_UDPAddr0) = inet_addr(DEFAULT_IPSTART);
	*((DWORD*)m_UDPAddr1) = inet_addr(DEFAULT_IPEND);
	m_hudp.setPort(DEFAULT_UDPPORT);
	m_hudp.setMaster(false);

	//WIC
	m_piFactory_r = NULL;
	m_piDecoder_r = NULL;
	m_piDecodeFrame_r = NULL;
	m_pPropertybag_r = NULL;
	m_piStream_r = NULL;
}

ELMaster::~ELMaster(void)
{
}

bool ELMaster::init()
{
	FileReader fr;
	Token tok;
	if(fr.open(INIFILE) == false) return false;
	while(fr.get1Line(tok) != false){
		if(tok.getSize() != 2) continue;
		//}`LXgAhX
		if(_strnicmp(tok.getData(0), "mcastaddr", 9) == 0){
			m_hudpm.setIP(inet_addr(tok.getData(1)));
		}
		//}`LXgO[vAhX
		else if(_strnicmp(tok.getData(0), "mcastgrp", 8) == 0){
			m_MCastGrp = atoi(tok.getData(1));
		}
		//UDPpIPAhX
		else if(_strnicmp(tok.getData(0), "udpaddr0", 8) == 0){
			*((DWORD*)m_UDPAddr0) = inet_addr(tok.getData(1));
		}
		else if(_strnicmp(tok.getData(0), "udpaddr1", 8) == 0){
			*((DWORD*)m_UDPAddr1) = inet_addr(tok.getData(1));
		}
	}
	fr.close();

	//WinSock̏
	WSADATA data;
	WSAStartup(MAKEWORD(2,2), &data);

	//j^̎擾
	m_mon.init();
	m_dskWidth  = m_mon.getWidth(0);
	m_dskHeight = m_mon.getHeight(0);

	//}`LXgp
	m_pMCastData0 = new BYTE [MCAST_BUFFER_SIZE];
	m_pMCastData = m_pMCastData0 + sizeof(MCAST_HEADER);

	//WIC̏
	if(::CoCreateInstance(CLSID_WICImagingFactory, NULL, CLSCTX_INPROC_SERVER, IID_IWICImagingFactory, (LPVOID*)&m_piFactory) != S_OK)
	{
		return false;
	}
	if(m_piFactory->CreateStream(&m_piStream) != S_OK) return false;
	if(m_piStream->InitializeFromMemory(m_pMCastData, MCAST_BUFFER_SIZE) != S_OK) return false;
	m_cbStride = (m_dskWidth * 24 + 7) / 8;
    m_cbBufferSize = m_dskHeight * m_cbStride;
	
	//Mp/////////////////////////////////////////////////////////
	//rbg}bvp
	LPDWORD lpdwPixel;
	HDC dskDC = ::GetDC(::GetDesktopWindow());

	m_memDC = CreateCompatibleDC(dskDC);
	ZeroMemory(&m_infoBM, sizeof(m_infoBM));
	m_infoBM.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	m_infoBM.bmiHeader.biBitCount = 24;
	m_infoBM.bmiHeader.biPlanes = 1;
	m_infoBM.bmiHeader.biWidth = m_dskWidth;
	m_infoBM.bmiHeader.biHeight = -m_dskHeight;
	m_memBM = CreateDIBSection(NULL, &m_infoBM, DIB_RGB_COLORS, (void **)(&lpdwPixel), NULL, 0);
	SelectObject(m_memDC, m_memBM);

	::ReleaseDC(::GetDesktopWindow(), dskDC);

	//Mp/////////////////////////////////////////////////////////
	m_pBM_r = new BYTE [m_dskWidth * m_dskHeight * 3];
	m_pFrame = new BYTE [FRAMESIZE + sizeof(UDP_RES_HEADER)];

	if(::CoCreateInstance(CLSID_WICImagingFactory, NULL, CLSCTX_INPROC_SERVER, IID_IWICImagingFactory, (LPVOID*)&m_piFactory_r) != S_OK)
	{
		return false;
	}

	m_fplog = fopen(LOGFILE, "at");

	return true;
}

bool ELMaster::destroy()
{
	//}`LXgMp
    m_piStream->Release();
	m_piFactory->Release();

	DeleteDC(m_memDC);
	DeleteObject(m_memBM);
	delete [] m_pMCastData0;
	
	//UDPMp
	m_piFactory_r->Release();

	delete [] m_pBM_r;
	delete [] m_pFrame;

	for(int i = 0; i < m_phi.size(); i++) delete m_phi[i];
	m_phi.clear();
	
	WSACleanup();

	fclose(m_fplog);

	return true;
}

//RTP SEND
bool ELMaster::startupMCast()
{
	bool ret;

	ret = m_sudpm.login(&m_hudpm, 0, NULL);

	if(ret == false){
		writeLog(m_sudpm.getErr());
		return false;
	}

	writeLog("startup mcast");
	return true;
}

bool ELMaster::cleanupMCast()
{
	m_sudpm.logout();
	writeLog("cleanup mcast");

	return true;
}

bool ELMaster::startupUDP()
{
	int i, ret;
	unsigned int cnum, ip;
	HDC dskDC = ::GetDC(::GetDesktopWindow());

	cnum =  ((m_UDPAddr1[0] * 256  + m_UDPAddr1[1]) * 256 + m_UDPAddr1[2]) * 256 + m_UDPAddr1[3];
	cnum -= ((m_UDPAddr0[0] * 256  + m_UDPAddr0[1]) * 256 + m_UDPAddr0[2]) * 256 + m_UDPAddr0[3];
	cnum++; // Ⴆ΁AIP̖110̏ꍇA10-1=91䏭ȂȂĂ܂̂ŁB

	for(i = 0; i < m_phi.size(); i++) delete m_phi[i];
	m_phi.clear();

	for(i = 0; i < cnum; i++){
		HostInfo *ptr = new HostInfo();
		ip = ((m_UDPAddr0[0] * 256  + m_UDPAddr0[1]) * 256 + m_UDPAddr0[2]) * 256 + m_UDPAddr0[3] + i;
		ptr->setIP(htonl(ip));
		ptr->setPort(DEFAULT_UDPPORT);
		ptr->setMaster(true);

		ptr->setMemDC(CreateCompatibleDC(dskDC));
		ptr->setMemBM(CreateCompatibleBitmap(dskDC, m_dskWidth, m_dskHeight));
		SelectObject(ptr->getMemDC(), ptr->getMemBM());

		ptr->AllocBuffer(UDP_BUFFER_SIZE);

		m_phi.push_back(ptr);
	}

	::ReleaseDC(::GetDesktopWindow(), dskDC);

	ret = m_sudp.login(&m_hudp, 0, NULL);
	if(ret == false){
		writeLog(m_sudp.getErr());
		return false;
	}

	writeLog("startup udp");

	return true;
}

bool ELMaster::cleanupUDP()
{
	m_sudp.logout();
	writeLog("cleanup udp");

	return true;
}

bool ELMaster::sendUdpCmd(unsigned char cmd)
{
	MCAST_HEADER frm;
	frm.group_id = m_MCastGrp;
	frm.message = cmd;
	frm.file_size = *(DWORD*)m_UDPAddr0;
	frm.frame_size = *(DWORD*)m_UDPAddr1;

	m_sudpm.send((const char*)&frm, sizeof(MCAST_HEADER), 0);

	return true;
}

bool ELMaster::recvUDP()
{
	bool ret;

	ret = m_sudp.recv((char*)m_pFrame, FRAMESIZE+sizeof(UDP_RES_HEADER), 10);
	if(ret == false) return false;

	UDP_RES_HEADER *purh = (UDP_RES_HEADER*)m_pFrame;
	char *str = (char*)m_pFrame + sizeof(UDP_RES_HEADER);
	int cid = purh->client_id;

	if(purh->message == ELP_SEND_INFO && cid < m_phi.size()){
		picojson::value v;
		parse(v, str, str + strlen(str));
		if(v.is<picojson::object>()){
			picojson::value host = v.get("host");
			if(host.is<string>()){
				m_phi[cid]->setHostname((char*)host.get<string>().c_str());
			}
			picojson::value user = v.get("user");
			if(user.is<string>()){
				m_phi[cid]->setUsername((char*)user.get<string>().c_str());
			}
		}

	    LV_ITEM itm;
		itm.mask = LVIF_TEXT;
		itm.iItem = purh->client_id;
		itm.pszText = (char*)m_phi[cid]->getHostname();
		itm.iSubItem = 0;
		ListView_SetItem(hList, &itm);
		itm.pszText = (char*)m_phi[cid]->getUsername();
		itm.iSubItem = 2;
		ListView_SetItem(hList, &itm);
	}
	else if(purh->message == ELP_SEND_JPEG && cid < m_phi.size()){
		if(purh->bend == true){
			//JpegfR[hiWICj
			int w = purh->width;
			int h = purh->height;
			WICRect rcImg = { 0, 0, w, h };
			if(m_piFactory_r->CreateStream(&m_piStream_r) != S_OK) return false;
			if(m_piStream_r->InitializeFromMemory(m_phi[cid]->getBuffer(), UDP_BUFFER_SIZE) != S_OK) return false;
			if(m_piFactory_r->CreateDecoderFromStream(m_piStream_r, NULL, WICDecodeMetadataCacheOnLoad, &m_piDecoder_r) != S_OK) return false;
			if(m_piDecoder_r->GetFrame(0, &m_piDecodeFrame_r) != S_OK) return false;
			m_cbStride_r = (w * 24 + 7) / 8;
			if(m_piDecodeFrame_r->CopyPixels(&rcImg, m_cbStride_r, m_cbStride_r * h, m_pBM_r) != S_OK) return false;

			m_piDecodeFrame_r->Release();
			m_piDecoder_r->Release();
			m_piStream_r->Release();

			char *_pBMPInfo = new char [sizeof(BITMAPINFO) + sizeof(RGBQUAD) * 255];
			BITMAPINFO *pBMPInfo = (BITMAPINFO*) _pBMPInfo;
			ZeroMemory(pBMPInfo, sizeof(BITMAPINFO) + sizeof(RGBQUAD) * 255);
			pBMPInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
			pBMPInfo->bmiHeader.biPlanes = 1;
			pBMPInfo->bmiHeader.biCompression = BI_RGB;
			pBMPInfo->bmiHeader.biBitCount = 24;
			pBMPInfo->bmiHeader.biWidth = w;
			pBMPInfo->bmiHeader.biHeight = -h;
			pBMPInfo->bmiHeader.biSizeImage = w * h * 3;
			SetDIBits(m_phi[cid]->getMemDC(), m_phi[cid]->getMemBM(), 0, h, m_pBM_r, pBMPInfo, DIB_RGB_COLORS);
			delete [] _pBMPInfo;
		}else{
			char *block = (char*)(m_phi[cid]->getBuffer() + purh->position);
			memcpy(block , (const char*)(m_pFrame + sizeof(UDP_RES_HEADER)), FRAMESIZE);
		}
	}

	return true;
}

bool ELMaster::sendJPEG(BYTE *pData, int qfactor)
{
	int fsize = 0;

	//JpegkiWICj
	if(m_piFactory->CreateEncoder(GUID_ContainerFormatJpeg, NULL, &m_piEncoder) != S_OK) return false;
	if(m_piEncoder->Initialize(m_piStream, WICBitmapEncoderNoCache) != S_OK) return false;
    if(m_piEncoder->CreateNewFrame(&m_piBitmapFrame, &m_pPropertybag) != S_OK) return false;
	PROPBAG2 o = {0};
    VARIANT va;
    o.pstrName = L"ImageQuality";
    VariantInit(&va);
    va.vt = VT_R4;
	va.fltVal = (float)qfactor / 100.0;
    m_pPropertybag->Write(1, &o, &va);
    m_piBitmapFrame->Initialize(m_pPropertybag);

	if(m_piBitmapFrame->SetSize(m_dskWidth, m_dskHeight) != S_OK) return false;
	WICPixelFormatGUID formatGUID = GUID_WICPixelFormat24bppBGR;
	if(m_piBitmapFrame->SetPixelFormat(&formatGUID) != S_OK) return false;

	if(m_piBitmapFrame->WritePixels(m_dskHeight, m_cbStride, m_cbBufferSize, pData) != S_OK) return false;
	if(m_piBitmapFrame->Commit() != S_OK) return false;
    if(m_piEncoder->Commit() != S_OK) return false;
	LARGE_INTEGER zeroPos = {0, 0};
    ULARGE_INTEGER StreamSize = {0, 0};
    m_piStream->Seek(zeroPos, STREAM_SEEK_CUR, &StreamSize);
	fsize = StreamSize.QuadPart;
	
	m_piBitmapFrame->Release();
	m_pPropertybag->Release();
	m_piEncoder->Release();
	m_piStream->Seek(zeroPos, STREAM_SEEK_SET, &StreamSize);

	//FILE *fp = fopen("debug.jpg", "wb");
	//fwrite(m_pMCastData, 1, fsize, fp);
	//fclose(fp);

	int pos = 0;
	for(;;){
		MCAST_HEADER *pjpg = (MCAST_HEADER*)(m_pMCastData0 + pos);
		pjpg->group_id = m_MCastGrp;
		pjpg->message = ELP_SEND_JPEG;
		pjpg->file_size = fsize;
		pjpg->width = m_dskWidth;
		pjpg->height = m_dskHeight;
		pjpg->frame_size = FRAMESIZE;
		pjpg->position = pos;
		if(pos > fsize){
			pjpg->bend = true;
		}else{
			pjpg->bend = false;
		}

		//ɔ2x
		m_sudpm.send((const char*)pjpg, FRAMESIZE+sizeof(MCAST_HEADER), 0);
		if(pos > fsize) break;
		Sleep(1);
		m_sudpm.send((const char*)pjpg, FRAMESIZE+sizeof(MCAST_HEADER), 0);

		pos += FRAMESIZE;
	}

	return true;
}

bool ELMaster::sendWindowHide()
{
	MCAST_HEADER frm;
	frm.group_id = m_MCastGrp;
	frm.message = ELP_HIDE_WINDOW;

	//3x
	m_sudpm.send((const char*)&frm, sizeof(MCAST_HEADER), 0);
	Sleep(1);
	m_sudpm.send((const char*)&frm, sizeof(MCAST_HEADER), 0);
	Sleep(1);
	m_sudpm.send((const char*)&frm, sizeof(MCAST_HEADER), 0);

	return true;
}

bool ELMaster::sendWindowShow()
{
	MCAST_HEADER frm;
	frm.group_id = m_MCastGrp;
	frm.message = ELP_SHOW_WINDOW;

	//10bƂɑ̂1ɕt2x
	m_sudpm.send((const char*)&frm, sizeof(MCAST_HEADER), 0);
	Sleep(1);
	m_sudpm.send((const char*)&frm, sizeof(MCAST_HEADER), 0);

	return true;
}

void ELMaster::writeLog(char *str)
{
	SYSTEMTIME st;
	GetLocalTime(&st);
	fprintf(m_fplog, "%04d.%02d.%02d %02d:%02d:%02d < %s >\n",
		st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond, str);
	fflush(m_fplog);
}
