/*****************************************************************************
Copyright (C) 2026 All Rights Reserved.
by Takayuki WATANABE (University of Shizuoka),

$Version:		4. 0. 0. 1
$Author:		Takayuki WATANABE, University of Shizuoka, Japan
*****************************************************************************/
#include "ELAgent.h"

//BELAgent
ELAgent agent;

//EChE֘AO[oϐ
HINSTANCE hInst;			// ݂̃CX^X
TCHAR szTitle[256];			// ^Cg o[ eLXg
TCHAR szWindowClass[256];	// ^Cg o[ eLXg
HICON hIcon;
UINT nTrayIconID;
HMENU hMenu;
HWND hWnd = NULL;

RECT rectWnd;
RECT rectCWnd;
POINT posSCR;
POINT posSCRMax;

bool bDual;
bool bShow;

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
 	// TODO: ̈ʒuɃR[hLqĂB
	MSG msg;
	WNDCLASSEX wcex;
	HANDLE hudpmThread;

	hInst = hInstance;

	//COM̏
	::CoInitialize(NULL);

	//Windows10/11̉ʂ̊gkɑΉ
	SetProcessDpiAwarenessContext(DPI_AWARENESS_CONTEXT_PER_MONITOR_AWARE_V2);

	//ELAgent̏
	agent.init();
	agent.startupUDPM();
	bDual = agent.getMonitor().isDual();
	bShow = false;

	unsigned int threadID;
	hudpmThread = (HANDLE)_beginthreadex(NULL, 0, &udpmThread, NULL, 0, &threadID);


	//O[o XgO
	sprintf(szTitle, "ELAgent");
	sprintf(szWindowClass, "ELAgent");

	hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ELICON), IMAGE_ICON, 0, 0,  LR_SHARED|LR_DEFAULTCOLOR);

	wcex.cbSize = sizeof(WNDCLASSEX); 
	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInst;
	wcex.hIcon			= hIcon;
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPSTR)NULL;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= hIcon;
	RegisterClassEx( &wcex );

	//EChE̍쐬
	if(bDual == false && agent.getSingleMode() == EL_SMODE_WINDOW){
		hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW | WS_VSCROLL | WS_HSCROLL,
		  CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInst, NULL);
	}else{
		hWnd = CreateWindow(szWindowClass, szTitle, WS_POPUP,
		  CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInst, NULL);
	}

	if( !hWnd ) return FALSE;

	//^XNgCɃACRǉ
    NOTIFYICONDATA nid;
	nTrayIconID = 10001;
	nid.cbSize = sizeof(NOTIFYICONDATA);
	nid.hWnd = hWnd;
	nid.uID = nTrayIconID;
	nid.uCallbackMessage = MY_WM_TASKBAR;
	nid.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;
	nid.hIcon = hIcon;
	sprintf(nid.szTip, "ELAgent");
	Shell_NotifyIcon(NIM_ADD, &nid);

	hMenu = LoadMenu(hInst, MAKEINTRESOURCE(IDR_TRAYMENU));

	//EChE\
	ShowWindow( hWnd, SW_HIDE );
	UpdateWindow( hWnd );

	GetWindowRect(hWnd, &rectWnd);
	GetClientRect(hWnd, &rectCWnd);
	posSCR.x = posSCR.y = 0;
	posSCRMax.x = posSCRMax.y = 0;

	// C bZ[W [v:
	while( GetMessage(&msg, NULL, 0, 0) ){
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}

	//ELAgent̏I
	TerminateThread(hudpmThread, 0);

	agent.cleanupUDPM();
	agent.destroy();

	//COM̏I
	::CoUninitialize();

	return msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;

	switch( message ) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// j[Ỉ:
			switch( wmId ) 
			{
				case IDM_EXIT:
					{
						NOTIFYICONDATA nid;
						nid.cbSize = sizeof(NOTIFYICONDATA);
						nid.hWnd = hWnd;
						nid.uID = nTrayIconID;
						Shell_NotifyIcon(NIM_DELETE, &nid);
						DestroyMenu(hMenu);
						DestroyWindow(hWnd);
						PostQuitMessage(0);
					}
					break;
				default:
					return DefWindowProc( hWnd, message, wParam, lParam );
			}
			break;

		case WM_PAINT:
			if(bDual == false && agent.getSingleMode() == EL_SMODE_NONE) break;

			hdc = BeginPaint (hWnd, &ps);
			if(bDual == true || agent.getSingleMode() == EL_SMODE_FULL){
				StretchBlt(hdc, 0, 0, agent.m_dskWidth, agent.m_dskHeight,
					agent.m_memDC, 0, 0, agent.getMasterWidth(), agent.getMasterHeight(), SRCCOPY);
			}else{
				StretchBlt(hdc, -posSCR.x, -posSCR.y, agent.m_dskWidth, agent.m_dskHeight,
					agent.m_memDC, 0, 0, agent.getMasterWidth(), agent.getMasterHeight(), SRCCOPY);
			}

			EndPaint( hWnd, &ps );
			break;

		case MY_WM_HIDE_WINDOW:
			if(bShow == true){
				bShow = false;
				ShowWindow( hWnd, SW_HIDE );
			}
			break;

		case MY_WM_SHOW_WINDOW:
			if(bDual == false && agent.getSingleMode() == EL_SMODE_NONE) break;

			if(bDual == false && bShow == false){
				bShow = true;
				// WS_CAPTION  WS_THICKFRAME X^Cǉ
//				LONG val;
//				val = GetWindowLong(hWnd, GWL_STYLE);
//				val |= (WS_CAPTION | WS_THICKFRAME | WS_VSCROLL | WS_HSCROLL | WS_MINIMIZEBOX | WS_SYSMENU);
//				SetWindowLong(hWnd, GWL_STYLE, val);
/*
				ShowWindow( hWnd, SW_RESTORE);
				SetWindowPos(hWnd, HWND_NOTOPMOST,
					agent.getMonitor().getWidth(0) * 2 / 3,
					agent.getMonitor().getHeight(0) * 2 / 3,
					agent.getMonitor().getWidth(0) / 3,
					agent.getMonitor().getHeight(0) / 3, NULL);
				ShowWindow( hWnd, SW_MINIMIZE);
*/
				ShowWindow(hWnd, SW_MAXIMIZE);
				SetWindowPos(hWnd, HWND_TOPMOST,
					agent.getMonitor().getLeft(0),
					agent.getMonitor().getTop(0),
					agent.getMonitor().getWidth(0),
					agent.getMonitor().getHeight(0), NULL);

			}else if(bDual == true && bShow == false){
				bShow = true;
				// WS_CAPTION  WS_THICKFRAME X^C菜
//				LONG val;
//				val = GetWindowLong(hWnd, GWL_STYLE);
//				val ^= (WS_CAPTION | WS_THICKFRAME | WS_VSCROLL | WS_HSCROLL | WS_MINIMIZEBOX | WS_SYSMENU);
//				SetWindowLong(hWnd, GWL_STYLE, val);

				ShowWindow(hWnd, SW_MAXIMIZE);
//				SetWindowPos(hWnd, HWND_TOPMOST,
				SetWindowPos(hWnd, HWND_BOTTOM,
					agent.getMonitor().getLeft(1),
					agent.getMonitor().getTop(1),
					agent.getMonitor().getWidth(1),
					agent.getMonitor().getHeight(1), NULL);
			}
			break;

		case MY_WM_TASKBAR:
			if(wParam != nTrayIconID) break;
			if(lParam == WM_LBUTTONUP || lParam == WM_RBUTTONUP){
				POINT point;
				GetCursorPos(&point);
				TrackPopupMenu(GetSubMenu(hMenu, 0), TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y, 0, hWnd, NULL);
			}
			break;
		case WM_MOVING:
			GetWindowRect(hWnd, &rectWnd);
			break;

		case WM_SIZE:
/*			if(bDual == false){
				GetWindowRect(hWnd, &rectWnd);
				GetClientRect(hWnd, &rectCWnd);
				posSCRMax.x = agent.m_dskWidth - rectCWnd.right;
				posSCRMax.y = agent.m_dskHeight - rectCWnd.bottom;
				SetScrollRange(hWnd, SB_HORZ, 0, posSCRMax.x, FALSE);
				SetScrollRange(hWnd, SB_VERT, 0, posSCRMax.y, FALSE);
				if(posSCR.y > posSCRMax.y) posSCR.y = posSCRMax.y;
				if(posSCR.x > posSCRMax.x) posSCR.x = posSCRMax.x;
				SetScrollPos(hWnd, SB_VERT, posSCR.y, TRUE);
				SetScrollPos(hWnd, SB_HORZ, posSCR.x, TRUE);
				InvalidateRect(hWnd, NULL, FALSE);
			}
*/			break;
		case WM_VSCROLL:
			if(bDual == false){
				int yAdd;
				yAdd =	(LOWORD(wParam) == SB_TOP)        ? -posSCR.y :
						(LOWORD(wParam) == SB_BOTTOM)     ? posSCRMax.y -posSCR.y :
						(LOWORD(wParam) == SB_LINEUP)     ? -1 :
						(LOWORD(wParam) == SB_LINEDOWN)   ? +1 :
						(LOWORD(wParam) == SB_PAGEUP)     ? -10 :
						(LOWORD(wParam) == SB_PAGEDOWN)   ? +10 :
						(LOWORD(wParam) == SB_THUMBTRACK) ? HIWORD(wParam) - posSCR.y : 0;
				yAdd = min(yAdd, posSCRMax.y - posSCR.y);
				yAdd = max(yAdd, -posSCR.y);
				if(yAdd){
					posSCR.y += yAdd;
					SetScrollPos(hWnd, SB_VERT, posSCR.y, TRUE);
					InvalidateRect(hWnd, NULL, FALSE);
				}
			}
			break;

		case WM_HSCROLL:
			if(bDual == false){
				int xAdd;
				xAdd =	(LOWORD(wParam) == SB_LEFT)       ? -posSCR.x :
						(LOWORD(wParam) == SB_RIGHT)      ? posSCRMax.x -posSCR.x :
						(LOWORD(wParam) == SB_LINELEFT)   ? -1 :
						(LOWORD(wParam) == SB_LINERIGHT)  ? +1 :
						(LOWORD(wParam) == SB_PAGELEFT)   ? -10 :
						(LOWORD(wParam) == SB_PAGERIGHT)  ? +10 :
						(LOWORD(wParam) == SB_THUMBTRACK) ? HIWORD(wParam) - posSCR.x : 0;
				xAdd = min(xAdd, posSCRMax.x - posSCR.x);
				xAdd = max(xAdd, -posSCR.x);
				if(xAdd){
					posSCR.x += xAdd;
					SetScrollPos(hWnd, SB_HORZ, posSCR.x, TRUE);
					InvalidateRect(hWnd, NULL, FALSE);
				}
			}
			break;

		case WM_DESTROY:
		case WM_CLOSE:
			break;

		default:
			return DefWindowProc( hWnd, message, wParam, lParam );
   }
   return 0;
}

unsigned int __stdcall udpmThread(void *pdata)
{

	while(1) {
		agent.recvUDPM();
	}

	_endthreadex(0);
	return 0;
}

unsigned int __stdcall udpThread(void *pdata)
{
	agent.sendUDP();

	_endthreadex(0);
	return 0;
}
