/*----------------------------------------------------------------------
ELAssit - ELAgent

Copyright (c) 2026, Takayuki WATANABE, All Rights Reserved.
http://www.groundnode.com/

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

$Version:		4. 0. 0. 1
$Data:		    Feb 11 2026
$Author:		Takayuki WATANABE
----------------------------------------------------------------------*/
#pragma once

#include <winsock2.h>
#include <ws2tcpip.h>
#include <windows.h>
#include <wincodec.h>
#include <wincodecsdk.h>
#include <string.h>
#include <process.h>
#include <iostream>
#include "../Util/System.h"
#include "../Util/Monitor.h"
#include "../Util/FileReader.h"
#include "../Util/SockTCP.h"
#include "../Util/SockUDP.h"
#include "../Util/SockUDPM.h"
#include "../Util/picojson.h"
#include "resource.h"
//NCu
#pragma comment(lib, "ws2_32.lib")
#pragma comment(lib, "WindowsCodecs.lib")

# pragma pack (1)

//lbg[N֘AftHgl
#define DEFAULT_UDPPORT		9375
#define DEFAULT_MCASTPORT	9376
#define DEFAULT_MCASTADDR	"224.1.2.3"
#define DEFAULT_MCASTGRP	0
#define DEFAULT_TIMEUP		10000

//obt@TCY
#define MCAST_BUFFER_SIZE	1000000
#define UDP_BUFFER_SIZE		1000000
#define FRAMESIZE			1400

//t@C
#define INIFILE				"elagent.ini"
#define LOGFILE				"elagent.log"

//ǉEChEbZ[W
#define MY_WM_HIDE_WINDOW		(WM_USER+20)
#define MY_WM_SHOW_WINDOW		(WM_USER+21)
#define MY_WM_TASKBAR			(WM_USER+22)

//EChEXe[^X
#define EL_WINDOW_HIDE			0
#define EL_WINDOW_SHOW			1

//vgR
#define ELP_HIDE_WINDOW			0x00
#define ELP_SHOW_WINDOW			0x01
#define ELP_SEND_JPEG			0x02
#define ELP_GET_INFO			0x03
#define ELP_SEND_INFO			0x04

//VOEChE̓샂[h
#define EL_SMODE_NONE			0	//
#define EL_SMODE_FULL			1	//t\
#define EL_SMODE_WINDOW			2	//EChE\

//}`LXgwb_tH[}bg
struct MCAST_HEADER
{
	unsigned char group_id;		//O[vԍi0-255j
	unsigned char message;		//vgR
	unsigned int file_size;		//t@CTCY
	unsigned int frame_size;	//t[TCY
	unsigned int position;		//ʒu
	unsigned short width;		//
	unsigned short height;		//
	bool bend;					//t@CIw
};

//UDPX|Xwb_tH[}bg
struct UDP_RES_HEADER
{
	unsigned short client_id;	//NCAgԍi0-65,535j
	unsigned char message;		//vgR
	unsigned int file_size;		//t@CTCY
	unsigned int frame_size;	//t[TCY
	unsigned int position;		//ʒu
	unsigned short width;		//
	unsigned short height;		//
	bool bend;					//t@CIw
};

//ELAgentNX
class ELAgent
{
public:
	ELAgent(void);
	virtual ~ELAgent(void);

	bool init();
	bool destroy();

	bool startupUDPM();
	bool cleanupUDPM();
	int  recvUDPM();
	int  sendUDP();

//	bool doTCP();

	void writeLog(char *str);

	Monitor &getMonitor(){ return m_mon; }
	System &getSystem(){ return m_sys; }

	int getSingleMode(){ return m_singleMode; }
	int getMasterWidth(){ return m_masterWidth; }
	int getMasterHeight(){ return m_masterHeight; }

	//th֐
	friend LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	friend unsigned int __stdcall udpmThread(void *pdata);
	friend unsigned int __stdcall udpThread(void *pdata);

protected:
	//IP}`LXgp
	SockUDPM m_sudpm;
	HostInfo m_hudpm;
	DWORD m_MCastGrp;

	//UDPp
	unsigned char m_Addr[4];
	unsigned char m_Addr0[4];
	unsigned char m_Addr1[4];
	unsigned short m_client_id;
	SockUDP m_sudp;
	HostInfo m_hudp;
	HANDLE m_hudpThread;
	
	//Mrbg}bvp
	HDC m_memDC;
	HBITMAP m_memBM;
	int m_dskWidth;		//̃j^
	int m_dskHeight;
	int m_masterWidth;	//}X^̃j^
	int m_masterHeight;
	//JPEGp
	BYTE *m_pJPG;
	BYTE *m_pJPG0;
	BYTE *m_pFrame;
	BYTE *m_pBM;

	IWICImagingFactory *m_piFactory;
	IWICBitmapDecoder *m_piDecoder;
	IWICBitmapFrameDecode *m_piDecodeFrame;
	IPropertyBag2 *m_pPropertybag;
	IWICStream *m_piStream;
	UINT m_cbStride;
    UINT m_cbBufferSize;

	//Mrbg}bvp
	HDC m_memDC_s;
	HBITMAP m_memBM_s;
	BITMAPINFO m_infoBM_s;
	int m_dskWidth_s;
	int m_dskHeight_s;
	BYTE *m_pUdpData;
	BYTE *m_pUdpData0;
	int m_qfactor;

	IWICImagingFactory *m_piFactory_s;
	IWICBitmapEncoder *m_piEncoder_s;
	IWICBitmapFrameEncode *m_piBitmapFrame_s;
	IPropertyBag2 *m_pPropertybag_s;
	IWICStream *m_piStream_s;
	UINT m_cbStride_s;
    UINT m_cbBufferSize_s;

	int m_wndState;		//EChȄ
	int m_singleMode;	//VOEChE̓샂[h

	System m_sys;		//VXe
	Monitor m_mon;		//j^

	FILE *m_fplog;
};
