/*----------------------------------------------------------------------
ELAssit - ELAgent

Copyright (c) 2026, Takayuki WATANABE, All Rights Reserved.
http://www.groundnode.com/

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

$Version:		4. 0. 0. 1
$Data:		    Feb 11 2026
$Author:		Takayuki WATANABE
----------------------------------------------------------------------*/
#include "ELAgent.h"

extern HWND hWnd;
extern POINT posSCR;

ELAgent::ELAgent(void)
{
	//ԂŃEChEB
	m_wndState = EL_WINDOW_HIDE;
	//ԂŃVOEChEȂ\[h
	m_singleMode = EL_SMODE_NONE;

	//}`LXgp
	m_hudpm.setIP(inet_addr(DEFAULT_MCASTADDR));
	m_hudpm.setPort(DEFAULT_MCASTPORT);
	m_hudpm.setMaster(false);
	m_MCastGrp = DEFAULT_MCASTGRP;

	//WIC
	m_piFactory = NULL;
	m_piDecoder = NULL;
	m_piDecodeFrame = NULL;
	m_pPropertybag = NULL;
	m_piStream = NULL;

	//UDPp
	m_hudp.setPort(DEFAULT_UDPPORT);
	m_hudp.setMaster(true);
	m_qfactor = 10;

	//WIC
	m_piFactory_s = NULL;
	m_piEncoder_s = NULL;
	m_piBitmapFrame_s = NULL;
	m_pPropertybag_s = NULL;
	m_piStream_s = NULL;
}

ELAgent::~ELAgent(void)
{
}

bool ELAgent::init()
{
	FileReader fr;
	Token tok;
	if(fr.open(INIFILE) == false) return false;
	while(fr.get1Line(tok) != false){
		if(tok.getSize() != 2) continue;
		//}`LXgAhX
		if(_strnicmp(tok.getData(0), "mcastaddr", 9) == 0){
			m_hudpm.setIP(inet_addr(tok.getData(1)));
		}
		//}`LXgO[vAhX
		else if(_strnicmp(tok.getData(0), "mcastgrp", 8) == 0){
			m_MCastGrp = atoi(tok.getData(1));
		}
		//VOEChẼ[h
		else if(_strnicmp(tok.getData(0), "smode", 5) == 0){
			m_singleMode = atoi(tok.getData(1));
		}
	}
	fr.close();

	//WinSock̏
	WSADATA data;
	WSAStartup(MAKEWORD(2,2), &data);

	//j^AVXe̎擾
	m_mon.init();
	m_sys.init();
	srand(m_sys.get()->ip[4]);

	//\TCYifAfBXvC̏ꍇlj
	if(m_mon.isDual() == false){
		m_dskWidth  = m_mon.getWidth(0);
		m_dskHeight = m_mon.getHeight(0);
		//Mp
		m_dskWidth_s  = m_mon.getWidth(0);
		m_dskHeight_s = m_mon.getHeight(0);
	}else{
		m_dskWidth  = m_mon.getWidth(1);
		m_dskHeight = m_mon.getHeight(1);
		//Mp
		m_dskWidth_s  = m_mon.getWidth(0);	//M͏ɃvC}j^
		m_dskHeight_s = m_mon.getHeight(0);
	}
	m_masterWidth = 0;
	m_masterHeight = 0;

	HDC dskDC = ::GetDC(::GetDesktopWindow());
	////////////////////////Mpݒ//////////////////////////////
	//rbg}bvp
    m_memDC = CreateCompatibleDC(dskDC);
    m_memBM = CreateCompatibleBitmap(dskDC, m_dskWidth, m_dskHeight);

    SelectObject(m_memDC, m_memBM);
	//m_pBM = new BYTE [m_dskWidth * m_dskHeight * 3];
	m_pBM = new BYTE[m_dskWidth * m_dskHeight * 10]; //]T

	//JPEGp
	m_pJPG0 = new BYTE [MCAST_BUFFER_SIZE];
	m_pJPG = m_pJPG0 + sizeof(MCAST_HEADER);
	m_pFrame = new BYTE [FRAMESIZE + sizeof(MCAST_HEADER)];

	//WIC̏
	if(::CoCreateInstance(CLSID_WICImagingFactory, NULL, CLSCTX_INPROC_SERVER, IID_IWICImagingFactory, (LPVOID*)&m_piFactory) != S_OK)
	{
		return false;
	}
	if(m_piFactory->CreateStream(&m_piStream) != S_OK) return false;
	if(m_piStream->InitializeFromMemory(m_pJPG, MCAST_BUFFER_SIZE) != S_OK) return false;


	////////////////////////Mpݒ//////////////////////////////
	m_client_id = 0;

	//UDPMp
	m_pUdpData0 = new BYTE [UDP_BUFFER_SIZE];
	m_pUdpData = m_pUdpData0 + sizeof(UDP_RES_HEADER);

	//WIC
	if(::CoCreateInstance(CLSID_WICImagingFactory, NULL, CLSCTX_INPROC_SERVER, IID_IWICImagingFactory, (LPVOID*)&m_piFactory_s) != S_OK)
	{
		return false;
	}
	if(m_piFactory_s->CreateStream(&m_piStream_s) != S_OK) return false;
	if(m_piStream_s->InitializeFromMemory(m_pUdpData, UDP_BUFFER_SIZE) != S_OK) return false;
	m_cbStride_s = (m_dskWidth_s * 24 + 7) / 8;
    m_cbBufferSize_s = m_dskHeight_s * m_cbStride_s;
	
	//rbg}bvp
	LPDWORD lpdwPixel;
	m_memDC_s = CreateCompatibleDC(dskDC);
	ZeroMemory(&m_infoBM_s, sizeof(m_infoBM_s));
	m_infoBM_s.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	m_infoBM_s.bmiHeader.biBitCount = 24;
	m_infoBM_s.bmiHeader.biPlanes = 1;
	m_infoBM_s.bmiHeader.biWidth = m_dskWidth_s;
	m_infoBM_s.bmiHeader.biHeight = -m_dskHeight_s;
	m_memBM_s = CreateDIBSection(NULL, &m_infoBM_s, DIB_RGB_COLORS, (void **)(&lpdwPixel), NULL, 0);
	SelectObject(m_memDC_s, m_memBM_s);

	//ݒ̌n
	::ReleaseDC(::GetDesktopWindow(), dskDC);

	m_hudpThread = NULL;

	m_fplog = fopen(LOGFILE, "at");
	
	return true;
}

bool ELAgent::destroy()
{
	//}`LXgMp
    m_piStream->Release();
	m_piFactory->Release();

	DeleteDC(m_memDC);
	DeleteObject(m_memBM);
	delete [] m_pBM;
	delete [] m_pJPG0;
	delete [] m_pFrame;

	//UDPMp
    m_piStream_s->Release();
	m_piFactory_s->Release();

	DeleteDC(m_memDC_s);
	DeleteObject(m_memBM_s);
	delete [] m_pUdpData0;

	WSACleanup();

	fclose(m_fplog);

	return true;
}

bool ELAgent::startupUDPM()
{
	bool ret;

	ret = m_sudpm.login(&m_hudpm, 0, NULL);
	if(ret == false){
		writeLog(m_sudpm.getErr());
		return false;
	}

	return true;
}

bool ELAgent::cleanupUDPM()
{
	m_sudpm.logout();
	writeLog("cleanup udpm");

	return true;
}

int ELAgent::recvUDPM()
{
	bool ret;

	ret = m_sudpm.recv((char*)m_pFrame, FRAMESIZE+sizeof(MCAST_HEADER), 10);
	if(ret == false) return false;

	MCAST_HEADER *pjpg = (MCAST_HEADER*)m_pFrame;

	if(pjpg->group_id != m_MCastGrp && pjpg->group_id != 2) return 0;

	if(m_mon.isDual() == true || m_singleMode != EL_SMODE_NONE){

		if(pjpg->message == ELP_HIDE_WINDOW){
			SendMessage(hWnd, MY_WM_HIDE_WINDOW, 0, 0L);

		}
		else if(pjpg->message == ELP_SHOW_WINDOW){
			SendMessage(hWnd, MY_WM_SHOW_WINDOW, 0, 0L);

		}
		else if(pjpg->message == ELP_SEND_JPEG && pjpg->bend == true){

			//JpegfR[hiWICj
			m_masterWidth = pjpg->width;
			m_masterHeight = pjpg->height;
			WICRect rcImg = { 0, 0, m_masterWidth, m_masterHeight };
			if (m_piFactory->CreateDecoderFromStream(m_piStream, NULL, WICDecodeMetadataCacheOnLoad, &m_piDecoder) != S_OK) return false;
			if (m_piDecoder->GetFrame(0, &m_piDecodeFrame) != S_OK) return false;
			m_cbStride = (m_masterWidth * 24 + 7) / 8;
			if (m_piDecodeFrame->CopyPixels(&rcImg, m_cbStride, m_cbStride * m_masterHeight, m_pBM) != S_OK) return false;

			m_piDecodeFrame->Release();
			m_piDecoder->Release();
			LARGE_INTEGER zeroPos = { 0, 0 };
			ULARGE_INTEGER StreamSize = { 0, 0 };
			m_piStream->Seek(zeroPos, STREAM_SEEK_SET, &StreamSize);

			char* _pBMPInfo = new char[sizeof(BITMAPINFO) + sizeof(RGBQUAD) * 255];
			BITMAPINFO* pBMPInfo = (BITMAPINFO*)_pBMPInfo;
			ZeroMemory(pBMPInfo, sizeof(BITMAPINFO) + sizeof(RGBQUAD) * 255);
			pBMPInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
			pBMPInfo->bmiHeader.biPlanes = 1;
			pBMPInfo->bmiHeader.biCompression = BI_RGB;
			pBMPInfo->bmiHeader.biBitCount = 24;
			pBMPInfo->bmiHeader.biWidth = m_masterWidth;
			pBMPInfo->bmiHeader.biHeight = -m_masterHeight;
			pBMPInfo->bmiHeader.biSizeImage = m_masterWidth * m_masterHeight * 3;
			SetDIBits(m_memDC, m_memBM, 0, m_masterHeight, m_pBM, pBMPInfo, DIB_RGB_COLORS);
			delete[] _pBMPInfo;

			HDC hdc = ::GetDC(hWnd);
			if (m_mon.isDual() == true) {
				StretchBlt(hdc, 0, 0, m_dskWidth, m_dskHeight, m_memDC, 0, 0, m_masterWidth, m_masterHeight, SRCCOPY);
			}
			else {
				StretchBlt(hdc, -posSCR.x, -posSCR.y, m_dskWidth, m_dskHeight, m_memDC, 0, 0, m_masterWidth, m_masterHeight, SRCCOPY);
			}
			::ReleaseDC(hWnd, hdc);
		}
		else if(pjpg->message == ELP_SEND_JPEG){
			char *block = (char*)(m_pJPG + pjpg->position);
			memcpy(block , (const char*)(m_pFrame + sizeof(MCAST_HEADER)), FRAMESIZE);
		}
	}

	if(pjpg->message == ELP_GET_INFO){
		*(DWORD*)m_Addr0 = pjpg->file_size;		//NCAg̊JnIP
		*(DWORD*)m_Addr1 = pjpg->frame_size;	//NCAg̏IIP
		m_sudpm.getFromIP(m_Addr);				//MasterIPAhX
		SYSINFO *psys = m_sys.get();			//gIPAhX

		int ip_s = m_Addr0[2]*256 + m_Addr0[3];
		int ip_e = m_Addr1[2]*256 + m_Addr1[3];
		int ip_m = psys->ip[2]*256 + psys->ip[3];
		m_client_id = ip_m - ip_s; //gIDԍ
		if(ip_e >= ip_m && ip_m >= ip_s){
			if(WaitForSingleObject(m_hudpThread, DEFAULT_TIMEUP) != WAIT_TIMEOUT){
				unsigned int threadID;
				m_hudpThread = (HANDLE)_beginthreadex(NULL, 0, &udpThread, NULL, 0, &threadID);
			}
		}
	}

	return ret;
}

int ELAgent::sendUDP()
{
	bool ret;
	UDP_RES_HEADER *udprh = (UDP_RES_HEADER*)m_pUdpData0;
	SYSINFO *psys = m_sys.get();

	//gtBbNWȂ悤IDɉĈ莞ԑ҂
	Sleep(m_client_id * 500);

	m_hudp.setIP(m_Addr);
	ret = m_sudp.login(&m_hudp, 0, NULL);
	if(ret == false){
		writeLog(m_sudpm.getErr());
		return false;
	}
	writeLog("startup udp");

	//zXgE[ȖM(JSON`)
	udprh->client_id = m_client_id;
	udprh->message = ELP_SEND_INFO;
	picojson::object pjo;
	pjo["host"] = (picojson::value)psys->hostname;
	pjo["user"] = (picojson::value)psys->username;
	picojson::value v(pjo);
	sprintf((char*)m_pUdpData, "%s", v.serialize().c_str());

	m_sudp.send((const char*)udprh, FRAMESIZE+sizeof(UDP_RES_HEADER), 0);
	Sleep(100);

	//XN[Lv`
	HDC dskDC = ::GetDC(::GetDesktopWindow());
	BitBlt(m_memDC_s, 0, 0, m_dskWidth_s, m_dskHeight_s, dskDC, 0, 0, SRCCOPY);
	::ReleaseDC(::GetDesktopWindow(), dskDC);

	//rbg}bvf[^̎擾
	BITMAPINFO info;
	ZeroMemory(&info, sizeof(BITMAPINFO));
	info.bmiHeader.biSize = sizeof(BITMAPINFO);
	int sz;
	BYTE *pData;
	GetDIBits(m_memDC_s, m_memBM_s, 0, m_dskHeight_s, NULL, &info, DIB_RGB_COLORS);
	sz = info.bmiHeader.biSizeImage;
	info.bmiHeader.biPlanes = 1;
	info.bmiHeader.biCompression = BI_RGB;
	info.bmiHeader.biBitCount = 24;
	info.bmiHeader.biHeight = -m_dskHeight_s;
	pData = new BYTE [sz];

	GetDIBits(m_memDC_s, m_memBM_s, 0, m_dskHeight_s, pData, &info, DIB_RGB_COLORS);
	int fsize = 0;

	//JpegkiWICj
	if(m_piFactory_s->CreateEncoder(GUID_ContainerFormatJpeg, NULL, &m_piEncoder_s) != S_OK) return false;
	if(m_piEncoder_s->Initialize(m_piStream_s, WICBitmapEncoderNoCache) != S_OK) return false;
    if(m_piEncoder_s->CreateNewFrame(&m_piBitmapFrame_s, &m_pPropertybag_s) != S_OK) return false;
	PROPBAG2 o = {0};
    VARIANT va;
    o.pstrName = L"ImageQuality";
    VariantInit(&va);
    va.vt = VT_R4;
	va.fltVal = (float)m_qfactor / 100.0;
    m_pPropertybag_s->Write(1, &o, &va);
    m_piBitmapFrame_s->Initialize(m_pPropertybag_s);

	if(m_piBitmapFrame_s->SetSize(m_dskWidth_s, m_dskHeight_s) != S_OK) return false;
	WICPixelFormatGUID formatGUID = GUID_WICPixelFormat24bppBGR;
	if(m_piBitmapFrame_s->SetPixelFormat(&formatGUID) != S_OK) return false;

	if(m_piBitmapFrame_s->WritePixels(m_dskHeight_s, m_cbStride_s, m_cbBufferSize_s, pData) != S_OK) return false;
	if(m_piBitmapFrame_s->Commit() != S_OK) return false;
    if(m_piEncoder_s->Commit() != S_OK) return false;
	LARGE_INTEGER zeroPos = {0, 0};
    ULARGE_INTEGER StreamSize = {0, 0};
    m_piStream_s->Seek(zeroPos, STREAM_SEEK_CUR, &StreamSize);
	fsize = StreamSize.QuadPart;
	
	m_piBitmapFrame_s->Release();
	m_pPropertybag_s->Release();
	m_piEncoder_s->Release();
	m_piStream_s->Seek(zeroPos, STREAM_SEEK_SET, &StreamSize);

//	FILE *fp = fopen("debug.jpg", "wb");
//	fwrite(m_pUdpData, 1, fsize, fp);
//	fclose(fp);

	int pos = 0;
	for(;;){
		UDP_RES_HEADER *pudp = (UDP_RES_HEADER*)(m_pUdpData0 + pos);
		pudp->client_id = m_client_id;
		pudp->message = ELP_SEND_JPEG;
		pudp->file_size = fsize;
		pudp->width = m_dskWidth_s;
		pudp->height = m_dskHeight_s;
		pudp->frame_size = FRAMESIZE;
		pudp->position = pos;
		if(pos > fsize){
			pudp->bend = true;
		}else{
			pudp->bend = false;
		}

		m_sudp.send((const char*)pudp, FRAMESIZE+sizeof(UDP_RES_HEADER), 0);
		if(pos > fsize) break;
		Sleep(10);

		pos += FRAMESIZE;
	}
	delete [] pData;

	m_sudp.logout();
	writeLog("cleanup udp");

	return true;
}
/*
bool ELAgent::doTCP()
{
	int w, h;
	m_stcp.login(&m_htcp, -1, NULL);

	SYSINFO *pSys = m_sys.get();
//	m_stcp.fp = m_fplog;
	m_stcp.send(pSys->hostname, 128, 2);
	m_stcp.send(pSys->username, 128, 2);
	m_stcp.send(pSys->desc, 128, 2);
	m_stcp.recv((char*)&w, sizeof(int), 2);
	m_stcp.recv((char*)&h, sizeof(int), 2);

	//XN[Lv`
	HDC dskDC = ::GetDC(::GetDesktopWindow());
    m_memDC_s = CreateCompatibleDC(dskDC);
    m_memBM_s = CreateCompatibleBitmap(dskDC, w, h);
    SelectObject(m_memDC_s, m_memBM_s);

	//	BitBlt(m_memDC_s, 0, 0, m_dskWidth_s, m_dskHeight_s, dskDC, 0, 0, SRCCOPY);
	SetStretchBltMode(m_memDC_s, COLORONCOLOR);
	StretchBlt(m_memDC_s, 0, 0, w, h, dskDC, 0, 0, m_dskWidth_s, m_dskHeight_s, SRCCOPY);
	::ReleaseDC(::GetDesktopWindow(), dskDC);

	BITMAPINFO info;
	ZeroMemory(&info, sizeof(BITMAPINFO));
	info.bmiHeader.biSize = sizeof(BITMAPINFO);
	int sz;
	BYTE *pData;
	GetDIBits(m_memDC_s, m_memBM_s, 0, h, NULL, &info, DIB_RGB_COLORS);
	sz = info.bmiHeader.biSizeImage;
	info.bmiHeader.biPlanes = 1;
	info.bmiHeader.biCompression = BI_RGB;
	info.bmiHeader.biBitCount = 24;
	pData = new BYTE [sz];

	GetDIBits(m_memDC_s, m_memBM_s, 0, h, pData, &info, DIB_RGB_COLORS);*/
/*
	//JPEGϊ
    m_image_s.DIBWidth  = w;
    m_image_s.DIBHeight = -h;
    m_image_s.JPGWidth	= w;
    m_image_s.JPGHeight = h;
	m_image_s.JPGSizeBytes = JPG_BUFFER_SIZE;
	m_image_s.DIBBytes     = pData;
	m_image_s.jquality     = 70;
	if(ijlWrite(&m_image_s, IJL_JBUFF_WRITEWHOLEIMAGE) != IJL_OK){
		delete [] pData;
		DeleteDC(m_memDC_s);
		DeleteObject(m_memBM_s);
		m_stcp.logout();
		return false;
	}
//	FILE *fpa = fopen("out.jpg", "wb");
//	fwrite(m_pJPG_s, 1, m_image_s.JPGSizeBytes, fpa);
//	fclose(fpa);

	m_stcp.send((const char*)&m_image_s.JPGSizeBytes, sizeof(int), 2);

//	int i;
//	for(i = 0; i < m_image_s.JPGSizeBytes; i += 1460){
//		m_stcp.send((const char*)(m_pJPG_s + i), min(m_image_s.JPGSizeBytes-i, 1460), 2);
//	}
	m_stcp.send((const char*)m_pJPG_s, m_image_s.JPGSizeBytes, 2);
	
	//ImF
	m_stcp.recv((char*)&w, sizeof(int), 100);
	*/
/*
	delete [] pData;
	DeleteDC(m_memDC_s);
	DeleteObject(m_memBM_s);

	m_stcp.logout();
	return true;
}
*/

void ELAgent::writeLog(char *str)
{
	SYSTEMTIME st;
	GetLocalTime(&st);
	fprintf(m_fplog, "%04d.%02d.%02d %02d:%02d:%02d < %s >\n",
		st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond, str);
}

